/*
 * Decompiled with CFR 0.152.
 */
package io.github.unknowncoder56.javaslc;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.unknowncoder56.javaslc.CommandListener;
import io.github.unknowncoder56.javaslc.ErrorListener;
import io.github.unknowncoder56.javaslc.MessageContext;
import io.github.unknowncoder56.javaslc.StartListener;
import io.github.unknowncoder56.javaslc.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class Bot
extends User {
    private String prefix;
    private StartListener startListener;
    private final String token;
    private final ArrayList<CommandListener> commandListeners;
    private final ArrayList<Long> serverIds = new ArrayList();

    Bot(String prefix, StartListener startListener, ErrorListener errorListener, String token, long userId, ArrayList<CommandListener> commandListeners) {
        super(userId, errorListener);
        this.prefix = prefix;
        this.startListener = startListener;
        this.token = token;
        this.commandListeners = commandListeners;
    }

    public void run() {
        if (this.prefix.isEmpty()) {
            throw new RuntimeException("Prefix not set.");
        }
        if (this.token.isEmpty()) {
            throw new RuntimeException("Token not set.");
        }
        if (this.userId == 0L) {
            throw new RuntimeException("Bot user ID not set.");
        }
        try {
            String responseJsonString = Request.get((String)("https://chat.slsearch.eu.org/api/user/" + this.userId + "/")).execute().returnContent().asString();
            JsonObject responseJson = JsonParser.parseString((String)responseJsonString).getAsJsonObject();
            JsonArray servers = responseJson.getAsJsonArray("servers");
            servers.forEach(server -> this.serverIds.add(Long.parseLong(server.getAsString())));
            if (this.startListener != null) {
                this.startListener.onStart();
            }
            Runnable runnable = this::checkForNewCommand;
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
            executor.scheduleAtFixedRate(runnable, 0L, 2500L, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            this.errorListener.onError(e, "run");
            System.out.println("Failed to start bot: " + e.getMessage());
        }
    }

    private void checkForNewCommand() {
        if (!this.commandListeners.isEmpty()) {
            for (long serverId : this.serverIds) {
                try {
                    String responseJsonString = Request.get((String)("https://chat.slsearch.eu.org/api/server/" + serverId + "/")).execute().returnContent().asString();
                    JsonArray messages = JsonParser.parseString((String)responseJsonString).getAsJsonObject().get("messages").getAsJsonArray();
                    JsonObject latestMessage = messages.get(messages.size() - 1).getAsJsonObject();
                    if (Objects.equals(latestMessage.get("owner").getAsString(), String.valueOf(this.userId)) || !latestMessage.get("content").getAsString().startsWith(this.prefix)) continue;
                    String[] commandParts = latestMessage.get("content").getAsString().split(" ");
                    if (commandParts.length > 1) {
                        String[] arguments = Arrays.copyOfRange(commandParts, 1, commandParts.length - 1);
                        this.commandListeners.forEach(commandListener -> commandListener.onCommand(new MessageContext(latestMessage, serverId, this, commandParts[0].substring(1), arguments)));
                        continue;
                    }
                    this.commandListeners.forEach(commandListener -> commandListener.onCommand(new MessageContext(latestMessage, serverId, this, commandParts[0].substring(1))));
                }
                catch (Exception e) {
                    if (this.errorListener != null) {
                        this.errorListener.onError(e, "checkNewCommand");
                    }
                    System.out.println("Failed to fetch server data of " + serverId);
                }
            }
        }
    }

    public CompletableFuture<Void> send(String message, long serverId) {
        return CompletableFuture.runAsync(() -> {
            if (this.serverIds.contains(serverId)) {
                try {
                    Request.post((String)"https://chat.slsearch.eu.org/api/send").bodyForm(() -> Arrays.asList(new BasicNameValuePair("message", message), new BasicNameValuePair("server_id", String.valueOf(serverId)), new BasicNameValuePair("token", this.token)).iterator()).addHeader("Content-Type", "application/x-www-form-urlencoded").execute();
                }
                catch (Exception e) {
                    this.errorListener.onError(e, "send");
                    System.out.println("Failed to send message to server " + serverId);
                }
            } else {
                if (this.errorListener != null) {
                    this.errorListener.onError(new Exception("Bot is not in server " + serverId), "send");
                }
                System.out.println("Bot is not in server " + serverId);
            }
        });
    }

    public CompletableFuture<Void> join(long serverId) {
        return CompletableFuture.runAsync(() -> {
            if (!this.serverIds.contains(serverId)) {
                try {
                    Request.post((String)"https://chat.slsearch.eu.org/api/new_server").bodyForm(() -> Arrays.asList(new BasicNameValuePair("server_id", String.valueOf(serverId)), new BasicNameValuePair("token", this.token)).iterator()).addHeader("Content-Type", "application/x-www-form-urlencoded").execute();
                    this.serverIds.add(serverId);
                    System.out.println("Current server IDs: " + this.serverIds);
                }
                catch (Exception e) {
                    if (this.errorListener != null) {
                        this.errorListener.onError(e, "join");
                    }
                    System.out.println("Failed to join server " + serverId);
                }
            } else {
                if (this.errorListener != null) {
                    this.errorListener.onError(new Exception("Bot is already in server " + serverId), "join");
                }
                System.out.println("Bot is already in server " + serverId);
            }
        });
    }

    public CompletableFuture<Void> change(ChangeKey changeKey, String changeValue) {
        return CompletableFuture.runAsync(() -> {
            String changeKeyString;
            switch (changeKey) {
                case PROFILE_IMAGE: {
                    changeKeyString = "profile_image";
                    break;
                }
                case NICKNAME: {
                    changeKeyString = "nickname";
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid change key.");
                }
            }
            try {
                Request.post((String)"https://chat.slsearch.eu.org/api/change").bodyForm(() -> Arrays.asList(new BasicNameValuePair("change_key", changeKeyString), new BasicNameValuePair("change_value", changeValue), new BasicNameValuePair("token", this.token)).iterator()).addHeader("Content-Type", "application/x-www-form-urlencoded").execute();
                System.out.println("Changed key " + changeKey + " into " + changeValue);
            }
            catch (Exception e) {
                if (this.errorListener != null) {
                    this.errorListener.onError(e, "change");
                }
                System.out.println("Failed to change key " + changeKey + " into " + changeValue);
            }
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public StartListener getStartListener() {
        return this.startListener;
    }

    public void setStartListener(StartListener startListener) {
        this.startListener = startListener;
    }

    public long getBotUserId() {
        return this.userId;
    }

    public ArrayList<CommandListener> getCommandListeners() {
        return this.commandListeners;
    }

    public void addCommandListener(CommandListener commandListener) {
        this.commandListeners.add(commandListener);
    }

    public static enum ChangeKey {
        PROFILE_IMAGE,
        NICKNAME;

    }
}

