/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import wf.core.game_engine.graphic.interfaces.ComponentRender;
import wf.core.game_engine.graphic.interfaces.PhysicCalculate;
import wf.core.game_engine.graphic.interfaces.PreRender;
import wf.core.game_engine.graphic.interfaces.listeners.for_component.ButtonListener;
import wf.core.game_engine.graphic.interfaces.listeners.for_component.InputListener;
import wf.core.game_engine.graphic.interfaces.listeners.frame.FrameResizedListener;
import wf.core.game_engine.graphic.interfaces.listeners.keyboard.KeyPressedListener;
import wf.core.game_engine.graphic.interfaces.listeners.keyboard.KeyReleasedListener;
import wf.core.game_engine.graphic.interfaces.listeners.keyboard.KeyTypedListener;
import wf.core.game_engine.graphic.interfaces.listeners.mouse.MouseClickedListener;
import wf.core.game_engine.graphic.interfaces.listeners.mouse.MouseDraggedListener;
import wf.core.game_engine.graphic.interfaces.listeners.mouse.MouseEnteredListener;
import wf.core.game_engine.graphic.interfaces.listeners.mouse.MouseExitedListener;
import wf.core.game_engine.graphic.interfaces.listeners.mouse.MousePressedListener;
import wf.core.game_engine.graphic.interfaces.listeners.mouse.MouseReleasedListener;
import wf.core.game_engine.graphic.interfaces.listeners.mouse.MouseWheeMovedListener;

public class WFengine
extends JFrame {
    private final JFrame frame;
    private int MAX_FPS = 85;
    private int MAX_TICKS = 85;
    private int fps;
    private int ticks;
    private int tempFps = this.MAX_FPS;
    private int tempTicks = this.MAX_TICKS;
    private boolean render = true;
    private boolean smooth = true;
    private final Thread physicTask;
    private final Thread renderTask;
    private final Thread rateTask;
    private List<ComponentRender> componentRenders = new CopyOnWriteArrayList<ComponentRender>();
    private List<ButtonListener> buttons = new CopyOnWriteArrayList<ButtonListener>();
    private List<InputListener> inputs = new CopyOnWriteArrayList<InputListener>();
    private List<PreRender> preRenders = new CopyOnWriteArrayList<PreRender>();
    private List<PhysicCalculate> physics = new CopyOnWriteArrayList<PhysicCalculate>();
    private List<KeyPressedListener> keyPressedListeners = new ArrayList<KeyPressedListener>();
    private List<KeyReleasedListener> keyReleasedListeners = new ArrayList<KeyReleasedListener>();
    private List<KeyTypedListener> keyTypedListeners = new ArrayList<KeyTypedListener>();
    private List<MousePressedListener> mousePressedListeners = new ArrayList<MousePressedListener>();
    private List<MouseDraggedListener> mouseDraggedListeners = new ArrayList<MouseDraggedListener>();
    private List<MouseClickedListener> mouseClickedListeners = new ArrayList<MouseClickedListener>();
    private List<MouseReleasedListener> mouseReleasedListeners = new ArrayList<MouseReleasedListener>();
    private List<MouseEnteredListener> mouseEnteredListeners = new ArrayList<MouseEnteredListener>();
    private List<MouseExitedListener> mouseExitedListeners = new ArrayList<MouseExitedListener>();
    private List<MouseWheeMovedListener> mouseWheelMovedListeners = new ArrayList<MouseWheeMovedListener>();
    private List<FrameResizedListener> frameResizedListeners = new ArrayList<FrameResizedListener>();

    public WFengine(String name, int width, int height) {
        super(name);
        this.add(new listener());
        this.setSize(width, height);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2 - 20);
        this.frame = this;
        this.physicTask = new Thread(() -> {
            while (true) {
                long calculationTime = System.nanoTime();
                ++this.tempTicks;
                for (PhysicCalculate pc : this.physics) {
                    try {
                        pc.calculatePhysic();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                int skippTime = (int)((double)(1000 / this.MAX_TICKS) - (double)(System.nanoTime() - calculationTime) / 1000000.0);
                if (skippTime <= 0) continue;
                try {
                    Thread.sleep(skippTime);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.renderTask = new Thread(() -> {
            while (true) {
                int skippTime;
                long calculationTime = System.nanoTime();
                ++this.tempFps;
                for (PreRender pr : this.preRenders) {
                    pr.preRender();
                }
                if (this.render) {
                    this.repaint();
                }
                if ((skippTime = (int)((double)(1000 / this.MAX_FPS) - (double)(System.nanoTime() - calculationTime) / 1000000.0)) <= 0) continue;
                try {
                    Thread.sleep(skippTime);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.rateTask = new Thread(() -> {
            while (true) {
                long calculationTime = System.nanoTime();
                this.fps = this.tempFps;
                this.ticks = this.tempTicks;
                this.tempFps = 0;
                this.tempTicks = 0;
                int skippTime = (int)(1000.0 - (double)(System.nanoTime() - calculationTime) / 1000000.0);
                if (skippTime <= 0) continue;
                try {
                    Thread.sleep(skippTime);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.physicTask.start();
        this.renderTask.start();
        this.rateTask.start();
    }

    public void stop() {
        this.dispose();
    }

    public void addComponent(ComponentRender cr) {
        this.componentRenders.add(cr);
    }

    public void addPreRender(PreRender cr) {
        this.preRenders.add(cr);
    }

    public void addPhysicCalculate(PhysicCalculate cr) {
        this.physics.add(cr);
    }

    public void removeComponent(ComponentRender cr) {
        this.componentRenders.remove(cr);
    }

    public void removePreRender(PreRender cr) {
        this.preRenders.remove(cr);
    }

    public void removePhysicCalculate(PhysicCalculate cr) {
        this.physics.remove(cr);
    }

    public void addKeyPressedListener(KeyPressedListener kl) {
        this.keyPressedListeners.add(kl);
    }

    public void addKeyTypedListener(KeyTypedListener kl) {
        this.keyTypedListeners.add(kl);
    }

    public void addKeyReleasedListener(KeyReleasedListener kl) {
        this.keyReleasedListeners.add(kl);
    }

    public void addMouseDraggedListener(MouseDraggedListener ml) {
        this.mouseDraggedListeners.add(ml);
    }

    public void addMousePressedListener(MousePressedListener ml) {
        this.mousePressedListeners.add(ml);
    }

    public void addMouseClickedListener(MouseClickedListener ml) {
        this.mouseClickedListeners.add(ml);
    }

    public void addMouseReleasedListener(MouseReleasedListener ml) {
        this.mouseReleasedListeners.add(ml);
    }

    public void addMouseEnteredListener(MouseEnteredListener ml) {
        this.mouseEnteredListeners.add(ml);
    }

    public void addMouseExitedListener(MouseExitedListener ml) {
        this.mouseExitedListeners.add(ml);
    }

    public void addMouseWheelMovedListener(MouseWheeMovedListener ml) {
        this.mouseWheelMovedListeners.add(ml);
    }

    public void addFrameResizedListener(FrameResizedListener fr) {
        this.frameResizedListeners.add(fr);
    }

    public void removeKeyPressedListener(KeyPressedListener kl) {
        this.keyPressedListeners.remove(kl);
    }

    public void removeKeyTypedListener(KeyTypedListener kl) {
        this.keyTypedListeners.remove(kl);
    }

    public void removeKeyReleasedListener(KeyReleasedListener kl) {
        this.keyReleasedListeners.remove(kl);
    }

    public void removeMouseDraggedListener(MouseDraggedListener ml) {
        this.mouseDraggedListeners.remove(ml);
    }

    public void removeMousePressedListener(MousePressedListener ml) {
        this.mousePressedListeners.remove(ml);
    }

    public void removeMouseClickedListener(MouseClickedListener ml) {
        this.mouseClickedListeners.remove(ml);
    }

    public void removeMouseReleasedListener(MouseReleasedListener ml) {
        this.mouseReleasedListeners.remove(ml);
    }

    public void removeMouseEnteredListener(MouseEnteredListener ml) {
        this.mouseEnteredListeners.remove(ml);
    }

    public void removeMouseExitedListener(MouseExitedListener ml) {
        this.mouseExitedListeners.remove(ml);
    }

    public void removeMouseWheelMovedListener(MouseWheeMovedListener ml) {
        this.mouseWheelMovedListeners.remove(ml);
    }

    public void removeFrameResizedListener(FrameResizedListener fr) {
        this.frameResizedListeners.remove(fr);
    }

    public boolean isRender() {
        return this.render;
    }

    public void setRender(boolean render) {
        this.render = render;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean smooth) {
        this.smooth = smooth;
    }

    public List<ComponentRender> getComponentRenders() {
        return this.componentRenders;
    }

    public void setComponentRenders(List<ComponentRender> componentRenders) {
        this.componentRenders = componentRenders;
    }

    public List<PreRender> getPreRenders() {
        return this.preRenders;
    }

    public void setPreRenders(List<PreRender> preRenders) {
        this.preRenders = preRenders;
    }

    public List<PhysicCalculate> getPhysics() {
        return this.physics;
    }

    public void setPhysics(List<PhysicCalculate> physics) {
        this.physics = physics;
    }

    public List<KeyPressedListener> getKeyPressedListeners() {
        return this.keyPressedListeners;
    }

    public void setKeyPressedListeners(List<KeyPressedListener> keyPressedListeners) {
        this.keyPressedListeners = keyPressedListeners;
    }

    public List<KeyReleasedListener> getKeyReleasedListeners() {
        return this.keyReleasedListeners;
    }

    public void setKeyReleasedListeners(List<KeyReleasedListener> keyReleasedListeners) {
        this.keyReleasedListeners = keyReleasedListeners;
    }

    public List<KeyTypedListener> getKeyTypedListeners() {
        return this.keyTypedListeners;
    }

    public void setKeyTypedListeners(List<KeyTypedListener> keyTypedListeners) {
        this.keyTypedListeners = keyTypedListeners;
    }

    public List<MousePressedListener> getMousePressedListeners() {
        return this.mousePressedListeners;
    }

    public int getMAX_FPS() {
        return this.MAX_FPS;
    }

    public void setMAX_FPS(int MAX_FPS) {
        this.MAX_FPS = MAX_FPS;
    }

    public int getMAX_TICKS() {
        return this.MAX_TICKS;
    }

    public void setMAX_TICKS(int MAX_TICKS) {
        this.MAX_TICKS = MAX_TICKS;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public void setRateTask(Timer rateTask) {
    }

    public List<MouseWheeMovedListener> getMouseWheelMovedListeners() {
        return this.mouseWheelMovedListeners;
    }

    public void setMouseWheelMovedListeners(List<MouseWheeMovedListener> mouseWheelMovedListener) {
        this.mouseWheelMovedListeners = mouseWheelMovedListener;
    }

    public void setMousePressedListeners(List<MousePressedListener> mousePressedListeners) {
        this.mousePressedListeners = mousePressedListeners;
    }

    public List<MouseDraggedListener> getMouseDraggedListeners() {
        return this.mouseDraggedListeners;
    }

    public void setMouseDraggedListeners(List<MouseDraggedListener> mouseDraggedListeners) {
        this.mouseDraggedListeners = mouseDraggedListeners;
    }

    public List<MouseClickedListener> getMouseClickedListeners() {
        return this.mouseClickedListeners;
    }

    public void setMouseClickedListeners(List<MouseClickedListener> mouseClickedListener) {
        this.mouseClickedListeners = mouseClickedListener;
    }

    public List<MouseReleasedListener> getMouseReleasedListeners() {
        return this.mouseReleasedListeners;
    }

    public void setMouseReleasedListeners(List<MouseReleasedListener> mouseReleasedListener) {
        this.mouseReleasedListeners = mouseReleasedListener;
    }

    public List<MouseEnteredListener> getMouseEnteredListeners() {
        return this.mouseEnteredListeners;
    }

    public void setMouseEnteredListeners(List<MouseEnteredListener> mouseEnteredListener) {
        this.mouseEnteredListeners = mouseEnteredListener;
    }

    public List<MouseExitedListener> getMouseExitedListeners() {
        return this.mouseExitedListeners;
    }

    public void setMouseExitedListeners(List<MouseExitedListener> mouseExitedListener) {
        this.mouseExitedListeners = mouseExitedListener;
    }

    public void addComponent(ButtonListener button) {
        this.buttons.add(button);
    }

    public void addComponent(InputListener input) {
        this.inputs.add(input);
    }

    public void removeComponent(ButtonListener button) {
        this.buttons.remove(button);
    }

    public void removeComponent(InputListener button) {
        this.inputs.remove(button);
    }

    private class listener
    extends JPanel {
        @Override
        public void paint(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (WFengine.this.smooth) {
                g2.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            }
            for (ComponentRender componentRender : WFengine.this.componentRenders) {
                try {
                    componentRender.render(g);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
            for (ButtonListener button : WFengine.this.buttons) {
                button.render(g, WFengine.this.frame.isFocused() && button.isOnButton((int)mousePoint.getX() - WFengine.this.frame.getX() - 8, (int)mousePoint.getY() - WFengine.this.frame.getY() - 31));
            }
            for (InputListener input : WFengine.this.inputs) {
                input.render(g, WFengine.this.frame.isFocused() && input.isOnInput((int)mousePoint.getX() - WFengine.this.frame.getX() - 8, (int)mousePoint.getY() - WFengine.this.frame.getY() - 31));
            }
        }

        public listener() {
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    for (KeyTypedListener kl : WFengine.this.keyTypedListeners) {
                        kl.keyTyped(e);
                    }
                    for (InputListener il : WFengine.this.inputs) {
                        il.press(e);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    for (KeyReleasedListener kl : WFengine.this.keyReleasedListeners) {
                        kl.keyReleased(e);
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    for (KeyPressedListener kl : WFengine.this.keyPressedListeners) {
                        kl.keyPressed(e);
                    }
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    for (MouseClickedListener ms : WFengine.this.mouseClickedListeners) {
                        ms.mouseClicked(e);
                    }
                    for (InputListener il : WFengine.this.inputs) {
                        il.click(e.getButton(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    for (MousePressedListener ms : WFengine.this.mousePressedListeners) {
                        ms.mousePressed(e);
                    }
                    for (ButtonListener button : WFengine.this.buttons) {
                        button.press(e.getButton(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    for (MouseReleasedListener ms : WFengine.this.mouseReleasedListeners) {
                        ms.mouseReleased(e);
                    }
                    for (ButtonListener button : WFengine.this.buttons) {
                        button.released(e.getButton(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    for (MouseEnteredListener ms : WFengine.this.mouseEnteredListeners) {
                        ms.mouseEntered(e);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    for (MouseExitedListener ms : WFengine.this.mouseExitedListeners) {
                        ms.mouseExited(e);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    for (MouseDraggedListener ms : WFengine.this.mouseDraggedListeners) {
                        ms.mouseDragged(e);
                    }
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    for (MouseWheeMovedListener ms : WFengine.this.mouseWheelMovedListeners) {
                        ms.mouseWheelMoved(e);
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    for (FrameResizedListener fr : WFengine.this.frameResizedListeners) {
                        fr.componentResized(e);
                    }
                }
            });
            this.setFocusable(true);
        }
    }
}

