/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.buttons;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import wf.core.game_engine.graphic.components.renders.BorderRender;
import wf.core.game_engine.graphic.components.renders.ImageRender;
import wf.core.game_engine.graphic.interfaces.listeners.for_component.ButtonListener;

public class ImageButton
extends ImageRender
implements ButtonListener {
    private Runnable runnable;
    private Color hoverColor;
    private Color clickColor;
    private Color backgroundColor;
    private boolean pressed;
    private int roundW;
    private int roundH;
    private int button;
    private BorderRender border;

    public ImageButton(Runnable runnable, BufferedImage image, Color backgroundColor, int button, Color hoverColor, Color clickColor, int roundW, int roundH, double x, double y, int width, int height, BorderRender border) {
        super(image, x, y, width, height);
        this.runnable = runnable;
        this.button = button;
        this.backgroundColor = backgroundColor;
        this.hoverColor = hoverColor;
        this.clickColor = clickColor;
        this.roundW = roundW;
        this.roundH = roundH;
        this.border = border;
    }

    @Override
    public boolean isOnButton(int x, int y) {
        return (double)x > this.getX() && (double)y > this.getY() && (double)x < this.getX() + (double)this.getWidth() && (double)y < this.getY() + (double)this.getHeight();
    }

    @Override
    public void render(Graphics graphics, boolean isHover) {
        if (!this.isRender()) {
            return;
        }
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRoundRect((int)this.getX(), (int)this.getY(), this.getWidth(), this.getHeight(), this.roundW, this.roundH);
        }
        if (this.pressed) {
            graphics.setColor(this.clickColor);
            graphics.fillRoundRect((int)this.getX(), (int)this.getY(), this.getWidth(), this.getHeight(), this.roundW, this.roundH);
        } else if (isHover) {
            graphics.setColor(this.hoverColor);
            graphics.fillRoundRect((int)this.getX(), (int)this.getY(), this.getWidth(), this.getHeight(), this.roundW, this.roundH);
        }
        this.render(graphics);
        if (this.border != null) {
            this.border.setX(this.getX());
            this.border.setY(this.getY());
            this.border.setWidth(this.getWidth());
            this.border.setHeight(this.getHeight());
            this.border.render(graphics);
        }
    }

    @Override
    public void press(int button, int x, int y) {
        if (button != this.button) {
            return;
        }
        this.pressed = this.isOnButton(x, y);
    }

    @Override
    public void released(int button, int x, int y) {
        if (button != this.button) {
            return;
        }
        this.pressed = false;
        if (this.isOnButton(x, y)) {
            this.runnable.run();
        }
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
    }

    public Color getClickColor() {
        return this.clickColor;
    }

    public void setClickColor(Color clickColor) {
        this.clickColor = clickColor;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public int getRoundW() {
        return this.roundW;
    }

    public void setRoundW(int roundW) {
        this.roundW = roundW;
    }

    public int getRoundH() {
        return this.roundH;
    }

    public void setRoundH(int roundH) {
        this.roundH = roundH;
    }
}

