/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.buttons;

import java.awt.Color;
import java.awt.Graphics;
import wf.core.game_engine.graphic.components.renders.BorderRender;
import wf.core.game_engine.graphic.components.renders.TextRender;
import wf.core.game_engine.graphic.interfaces.listeners.for_component.ButtonListener;

public class TextButton
extends TextRender
implements ButtonListener {
    private Runnable runnable;
    private Color hoverColor = Color.gray;
    private Color clickColor = Color.black;
    private Color backgroundColor;
    private boolean pressed = false;
    private int roundW = 0;
    private int roundH = 0;
    private int button = 1;
    private int width = 20;
    private int height = 20;
    private double x;
    private double y;
    private BorderRender border;

    public TextButton(Runnable runnable, double x, double y, int width, int height, Color backgroundColor, double textX, double textY, String text, Float fontSize, Color textColor, int button, Color hoverColor, Color clickColor, int roundW, int roundH, BorderRender border) {
        super(text, x + textX, y + textY, fontSize.floatValue(), textColor);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.runnable = runnable;
        this.button = button;
        this.hoverColor = hoverColor;
        this.clickColor = clickColor;
        this.backgroundColor = backgroundColor;
        this.roundW = roundW;
        this.roundH = roundH;
        this.border = border;
    }

    @Override
    public boolean isOnButton(int x, int y) {
        return (double)x > this.x && (double)y > this.y && (double)x < this.x + (double)this.width && (double)y < this.y + (double)this.height;
    }

    @Override
    public void render(Graphics graphics, boolean isHover) {
        if (!this.isRender()) {
            return;
        }
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRoundRect((int)this.x, (int)this.y, this.width, this.height, this.roundW, this.roundH);
        }
        if (this.pressed) {
            graphics.setColor(this.clickColor);
            graphics.fillRoundRect((int)this.x, (int)this.y, this.width, this.height, this.roundW, this.roundH);
        } else if (isHover) {
            graphics.setColor(this.hoverColor);
            graphics.fillRoundRect((int)this.x, (int)this.y, this.width, this.height, this.roundW, this.roundH);
        }
        this.render(graphics);
        if (this.border != null) {
            this.border.setX(this.x);
            this.border.setY(this.y);
            this.border.setWidth(this.width);
            this.border.setHeight(this.height);
            this.border.render(graphics);
        }
    }

    @Override
    public void press(int button, int x, int y) {
        if (button != this.button) {
            return;
        }
        this.pressed = this.isOnButton(x, y);
    }

    @Override
    public void released(int button, int x, int y) {
        if (button != this.button) {
            return;
        }
        this.pressed = false;
        if (this.isOnButton(x, y)) {
            this.runnable.run();
        }
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
    }

    public Color getClickColor() {
        return this.clickColor;
    }

    public void setClickColor(Color clickColor) {
        this.clickColor = clickColor;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public int getRoundW() {
        return this.roundW;
    }

    public void setRoundW(int roundW) {
        this.roundW = roundW;
    }

    public int getRoundH() {
        return this.roundH;
    }

    public void setRoundH(int roundH) {
        this.roundH = roundH;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getButtonX() {
        return this.x;
    }

    public void setButtonX(double x) {
        this.x = x;
    }

    public double getButtonY() {
        return this.y;
    }

    public void setButtonY(double y) {
        this.y = y;
    }

    public BorderRender getBorder() {
        return this.border;
    }

    public void setBorder(BorderRender border) {
        this.border = border;
    }
}

