/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.models;

import wf.core.game_engine.graphic.components.models.Line;
import wf.core.game_engine.graphic.components.models.Point;
import wf.core.game_engine.graphic.utils.PosUtils;

public class Ray
extends Line {
    private double distance;
    private boolean intersect = false;
    private Point intersectPoint;
    private double angle;

    public Ray(Point p1, Point p2, double angle) {
        super(p1, p2);
        this.angle = angle;
    }

    public void calculate(Line[] lines) {
        for (Line line : lines) {
            if (!PosUtils.intersectsLines(line, this)) continue;
            this.intersect = true;
            this.intersectPoint = PosUtils.crossingPoint(line, this);
            this.distance = PosUtils.getDistance(this.getP1(), this.intersectPoint);
            return;
        }
        this.distance = -1.0;
        this.intersect = false;
    }

    public Line getCalculatedRay() {
        return new Line(new Point(this.getP1().getX(), this.getP1().getY()), PosUtils.far(this.getP1(), this.distance, this.angle));
    }

    @Override
    public String toString() {
        return "Ray{distance=" + this.distance + ", intersect=" + this.intersect + ", intersectPoint=" + this.intersectPoint + ", angle=" + this.angle + '}';
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public boolean isIntersect() {
        return this.intersect;
    }

    public void setIntersect(boolean intersect) {
        this.intersect = intersect;
    }

    public Point getIntersectPoint() {
        return this.intersectPoint;
    }

    public void setIntersectPoint(Point intersectPoint) {
        this.intersectPoint = intersectPoint;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }
}

