/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import wf.core.game_engine.graphic.components.Component;
import wf.core.game_engine.graphic.interfaces.ComponentRender;

public class BorderRender
extends Component
implements ComponentRender {
    private Color borderColor;
    private int width;
    private int height;
    private float size;
    private int roundW;
    private int roundH;

    public BorderRender(double x, double y, Color borderColor, int width, int height, float size, int roundW, int roundH) {
        super(x, y);
        this.borderColor = borderColor;
        this.width = width;
        this.height = height;
        this.size = size;
        this.roundW = roundW;
        this.roundH = roundH;
    }

    @Override
    public void render(Graphics g) {
        if (!this.isRender()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(this.size));
        g.setColor(this.borderColor);
        g.drawRoundRect((int)this.getX(), (int)this.getY(), this.width, this.height, this.roundH, this.roundH);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getSize() {
        return this.size;
    }

    public int getRoundW() {
        return this.roundW;
    }

    public int getRoundH() {
        return this.roundH;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setRoundW(int roundW) {
        this.roundW = roundW;
    }

    public void setRoundH(int roundH) {
        this.roundH = roundH;
    }
}

