/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import wf.core.game_engine.graphic.components.Component;
import wf.core.game_engine.graphic.interfaces.ComponentRender;

public class ImageRender
extends Component
implements ComponentRender {
    private BufferedImage image;
    private double rotate;
    private int width;
    private int height;

    public ImageRender(BufferedImage image, double x, double y, int width, int height, double rotate) {
        super(x, y);
        this.image = ImageRender.resize(image, width, height);
        this.rotate = rotate;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public ImageRender(BufferedImage image, double x, double y) {
        super(x, y);
        this.image = image;
        this.rotate = 0.0;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public ImageRender(BufferedImage image, double x, double y, double rotate) {
        super(x, y);
        this.image = image;
        this.rotate = rotate;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public ImageRender(BufferedImage image, double x, double y, int width, int height) {
        super(x, y);
        this.image = ImageRender.resize(image, width, height);
        this.rotate = 0.0;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    public ImageRender(BufferedImage image, double rotate) {
        super(0.0, 0.0);
        this.image = image;
        this.rotate = rotate;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public ImageRender(BufferedImage image) {
        super(0.0, 0.0);
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public void resize(int width, int height) {
        Image tmp = this.image.getScaledInstance(width, height, 4);
        BufferedImage new_img = new BufferedImage(width, height, 2);
        Graphics2D g2d = new_img.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        this.image = new_img;
    }

    public static BufferedImage resize(BufferedImage img, int width, int height) {
        Image tmp = img.getScaledInstance(width, height, 4);
        BufferedImage new_img = new BufferedImage(width, height, 2);
        Graphics2D g2d = new_img.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return new_img;
    }

    @Override
    public void render(Graphics g) {
        if (!this.isRender()) {
            return;
        }
        AffineTransform af = AffineTransform.getTranslateInstance(this.getX(), this.getY());
        af.rotate(Math.toRadians(this.rotate), (double)this.image.getWidth() / 2.0, (double)this.image.getHeight() / 2.0);
        Graphics2D graphics2d = (Graphics2D)g;
        graphics2d.drawImage(this.image, af, null);
    }

    public String toString() {
        return "ImageRender{image=" + this.image + ", rotate=" + this.rotate + ", width=" + this.width + ", height=" + this.height + '}';
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public double getRotate() {
        return this.rotate;
    }

    public double addRotate(double add) {
        return this.rotate += add;
    }

    public void setRotate(double rotate) {
        this.rotate = rotate;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

