/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import wf.core.game_engine.graphic.components.models.Line;
import wf.core.game_engine.graphic.interfaces.ComponentRender;

public class LineRender
implements ComponentRender {
    private Line line;
    private Color color;
    private int width;
    private boolean enable = true;
    private boolean render = true;

    public LineRender(Line line, Color color, int width) {
        this.line = line;
        this.color = color;
        this.width = width;
    }

    public LineRender(Line line, Color color, int width, boolean enable, boolean render) {
        this.line = line;
        this.color = color;
        this.width = width;
        this.enable = enable;
        this.render = render;
    }

    @Override
    public void render(Graphics g) {
        if (!this.render) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(this.width));
        g.setColor(this.color);
        g.drawLine((int)this.line.getP1().getX(), (int)this.line.getP1().getY(), (int)this.line.getP2().getX(), (int)this.line.getP2().getY());
    }

    public String toString() {
        return "LineRender{line=" + this.line + ", color=" + this.color + ", width=" + this.width + '}';
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line line) {
        this.line = line;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isRender() {
        return this.render;
    }

    public void setRender(boolean render) {
        this.render = render;
    }
}

