/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import wf.core.game_engine.graphic.components.Component;
import wf.core.game_engine.graphic.components.renders.TextRender;
import wf.core.game_engine.graphic.interfaces.ComponentRender;
import wf.core.game_engine.graphic.utils.MathUtils;

public class ProgressBarRender
extends Component
implements ComponentRender {
    private int width;
    private int height;
    private double progress;
    private TextRender text;
    private Color progressColor;
    private Color nonProgressColor;
    private Color borderColor;
    private double borderWidth;

    public ProgressBarRender(double x, double y, int width, int height, double progress, boolean textEnable, Color progressColor, Color nonProgressColor, Color borderColor, double borderWidth) {
        super(x, y);
        this.width = width;
        this.height = height;
        this.progress = progress;
        this.progressColor = progressColor;
        this.nonProgressColor = nonProgressColor;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
        if (textEnable) {
            this.text = new TextRender("", x + (double)width / 2.0 - 25.0, y + (double)height / 2.0 + 8.0, Color.black);
        }
    }

    @Override
    public void render(Graphics g) {
        if (!this.isRender()) {
            return;
        }
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            ((Graphics2D)g).setStroke(new BasicStroke((int)this.borderWidth + 2));
            g.drawLine((int)(this.getX() - this.borderWidth), (int)(this.getY() - this.borderWidth), (int)(this.getX() + (double)this.width + this.borderWidth), (int)(this.getY() - this.borderWidth));
            g.drawLine((int)(this.getX() - this.borderWidth), (int)(this.getY() - this.borderWidth), (int)(this.getX() - this.borderWidth), (int)(this.getY() + (double)this.height + this.borderWidth));
            g.drawLine((int)(this.getX() + (double)this.width + this.borderWidth), (int)(this.getY() - this.borderWidth), (int)(this.getX() + (double)this.width + this.borderWidth), (int)(this.getY() + (double)this.height + this.borderWidth));
            g.drawLine((int)(this.getX() - this.borderWidth), (int)(this.getY() + (double)this.height + this.borderWidth), (int)(this.getX() + (double)this.width + this.borderWidth), (int)(this.getY() + (double)this.height + this.borderWidth));
        }
        g.setColor(this.progressColor);
        g.fillRect((int)this.getX(), (int)this.getY(), (int)MathUtils.getPercent(this.width, this.progress), this.height);
        if (this.nonProgressColor != null) {
            g.setColor(this.nonProgressColor);
            g.fillRect((int)Math.round(this.getX() + MathUtils.getPercent(this.width, this.progress)), (int)this.getY(), (int)Math.round((double)this.width - MathUtils.getPercent(this.width, this.progress)), this.height);
        }
        this.text.setFontSize((float)(this.borderWidth * 10.0));
        this.text.setText(this.progress + "%");
        this.text.render(g);
    }

    public String toString() {
        return "ProgressBarRender{width=" + this.width + ", height=" + this.height + ", progress=" + this.progress + ", text=" + this.text + ", progressColor=" + this.progressColor + ", nonProgressColor=" + this.nonProgressColor + ", borderColor=" + this.borderColor + ", borderWidth=" + this.borderWidth + '}';
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public TextRender getText() {
        return this.text;
    }

    public void setText(TextRender text) {
        this.text = text;
    }

    public Color getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(Color progressColor) {
        this.progressColor = progressColor;
    }

    public Color getNonProgressColor() {
        return this.nonProgressColor;
    }

    public void setNonProgressColor(Color nonProgressColor) {
        this.nonProgressColor = nonProgressColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
    }
}

