/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import wf.core.game_engine.graphic.components.models.Line;
import wf.core.game_engine.graphic.components.models.Ray;
import wf.core.game_engine.graphic.interfaces.ComponentRender;

public class RayRender
implements ComponentRender {
    private Ray ray;
    private Color color = Color.white;
    private int width = 2;
    private boolean fullRender = true;
    private boolean circleRender = true;
    private Color circleColor = Color.black;
    private boolean enable = true;
    private boolean render = true;

    public RayRender(Ray ray) {
        this.ray = ray;
    }

    public RayRender(Ray ray, Color color) {
        this.ray = ray;
        this.color = color;
    }

    public RayRender(Ray ray, Color color, int width) {
        this.ray = ray;
        this.color = color;
        this.width = width;
    }

    public RayRender(Ray ray, Color color, boolean fullRender) {
        this.ray = ray;
        this.color = color;
        this.fullRender = fullRender;
    }

    public RayRender(Ray ray, Color color, int width, boolean fullRender) {
        this.ray = ray;
        this.color = color;
        this.width = width;
        this.fullRender = fullRender;
    }

    public RayRender(Ray ray, Color color, int width, boolean fullRender, boolean circleRender) {
        this.ray = ray;
        this.color = color;
        this.width = width;
        this.fullRender = fullRender;
        this.circleRender = circleRender;
    }

    public RayRender(Ray ray, Color color, int width, boolean fullRender, boolean circleRender, Color circleColor) {
        this.ray = ray;
        this.color = color;
        this.width = width;
        this.fullRender = fullRender;
        this.circleRender = circleRender;
        this.circleColor = circleColor;
    }

    public RayRender(Ray ray, Color color, int width, boolean fullRender, boolean circleRender, Color circleColor, boolean enable, boolean render) {
        this.ray = ray;
        this.color = color;
        this.width = width;
        this.fullRender = fullRender;
        this.circleRender = circleRender;
        this.circleColor = circleColor;
        this.enable = enable;
        this.render = render;
    }

    @Override
    public void render(Graphics g) {
        if (!this.render) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(this.color);
        g2.setStroke(new BasicStroke(this.width));
        if (this.fullRender) {
            g.drawLine((int)this.ray.getP1().getX(), (int)this.ray.getP1().getY(), (int)this.ray.getP2().getX(), (int)this.ray.getP2().getY());
        } else if (this.ray.isIntersect()) {
            Line drawLine = this.ray.getCalculatedRay();
            g.drawLine((int)drawLine.getP1().getX(), (int)drawLine.getP1().getY(), (int)drawLine.getP2().getX(), (int)drawLine.getP2().getY());
        }
        if (this.ray.isIntersect() && this.ray.getIntersectPoint() != null) {
            g.drawString(String.valueOf(Math.round(this.ray.getDistance())), (int)this.ray.getIntersectPoint().getX(), (int)(this.ray.getIntersectPoint().getY() + 20.0));
            g.setColor(this.circleColor);
            g.drawOval((int)this.ray.getIntersectPoint().getX() - 3, (int)this.ray.getIntersectPoint().getY() - 3, 5, 5);
        }
    }

    public String toString() {
        return "RayRender{ray=" + this.ray + ", color=" + this.color + ", width=" + this.width + ", fullRender=" + this.fullRender + ", circleRender=" + this.circleRender + ", circleColor=" + this.circleColor + '}';
    }

    public Ray getRay() {
        return this.ray;
    }

    public void setRay(Ray ray) {
        this.ray = ray;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isFullRender() {
        return this.fullRender;
    }

    public void setFullRender(boolean fullRender) {
        this.fullRender = fullRender;
    }

    public boolean isCircleRender() {
        return this.circleRender;
    }

    public void setCircleRender(boolean circleRender) {
        this.circleRender = circleRender;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isRender() {
        return this.render;
    }

    public void setRender(boolean render) {
        this.render = render;
    }
}

