/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import wf.core.game_engine.graphic.components.renders.BorderRender;
import wf.core.game_engine.graphic.components.renders.TextRender;
import wf.core.game_engine.graphic.interfaces.ComponentRender;
import wf.core.game_engine.graphic.interfaces.listeners.for_component.InputListener;

public class TextInputRender
extends TextRender
implements ComponentRender,
InputListener {
    private Runnable runnable;
    private double x;
    private double y;
    private int width = 20;
    private int height = 20;
    private Color hoverColor = Color.gray;
    private Color clickColor = Color.black;
    private Color backgroundColor;
    private int roundW = 0;
    private int roundH = 0;
    private int button = 1;
    private BorderRender border;
    private boolean isFocused = false;

    public TextInputRender(String text, double x, double y, float fontSize, Color color, Runnable runnable, int width, int height, Color hoverColor, Color clickColor, Color backgroundColor, int roundW, int roundH, int button, BorderRender border) {
        super(text, x, y, fontSize, color);
        this.x = x;
        this.y = y;
        this.runnable = runnable;
        this.width = width;
        this.height = height;
        this.hoverColor = hoverColor;
        this.clickColor = clickColor;
        this.backgroundColor = backgroundColor;
        this.roundW = roundW;
        this.roundH = roundH;
        this.button = button;
        this.border = border;
    }

    @Override
    public boolean isOnInput(int x, int y) {
        return (double)x > this.x && (double)y > this.y && (double)x < this.x + (double)this.width && (double)y < this.y + (double)this.height;
    }

    @Override
    public void render(Graphics graphics, boolean isHover) {
        if (!this.isRender()) {
            return;
        }
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRoundRect((int)this.x, (int)this.y, this.width, this.height, this.roundW, this.roundH);
        }
        if (this.isFocused) {
            graphics.setColor(this.clickColor);
            graphics.fillRoundRect((int)this.x, (int)this.y, this.width, this.height, this.roundW, this.roundH);
        } else if (isHover) {
            graphics.setColor(this.hoverColor);
            graphics.fillRoundRect((int)this.x, (int)this.y, this.width, this.height, this.roundW, this.roundH);
        }
        if (this.border != null) {
            this.border.setX(this.x);
            this.border.setY(this.y);
            this.border.setWidth(this.width);
            this.border.setHeight(this.height);
            this.border.render(graphics);
        }
        this.setX(this.x + 5.0);
        this.setY(this.y + (double)this.height / 2.0 + 5.0);
        this.render(graphics);
    }

    @Override
    public void click(int button, int x, int y) {
        if (button != this.button) {
            return;
        }
        this.isFocused = this.isOnInput(x, y);
    }

    @Override
    public void press(KeyEvent key) {
        if (!this.isFocused) {
            return;
        }
        if (String.valueOf(key.getKeyChar()).equals("\b")) {
            if (this.getText().isEmpty()) {
                return;
            }
            this.setText(this.getText().substring(0, this.getText().length() - 1));
        } else {
            this.setText(this.getText() + key.getKeyChar());
        }
    }
}

