/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders;

import java.awt.Color;
import java.awt.Graphics;
import wf.core.game_engine.graphic.components.Component;
import wf.core.game_engine.graphic.interfaces.ComponentRender;

public class TextRender
extends Component
implements ComponentRender {
    private String text;
    private float fontSize;
    private Color color;

    public TextRender(String text, double x, double y, float fontSize, Color color) {
        super(x, y);
        this.text = text;
        this.fontSize = fontSize;
        this.color = color;
    }

    public TextRender(String text, double x, double y, float fontSize) {
        super(x, y);
        this.text = text;
        this.fontSize = fontSize;
        this.color = Color.WHITE;
    }

    public TextRender(String text, double x, double y, Color color) {
        super(x, y);
        this.text = text;
        this.fontSize = 14.0f;
        this.color = color;
    }

    @Override
    public void render(Graphics g) {
        if (!this.isRender()) {
            return;
        }
        g.setColor(this.color);
        g.setFont(g.getFont().deriveFont(this.fontSize));
        g.drawString(this.text, (int)this.getX(), (int)this.getY());
    }

    public String toString() {
        return "TextRender{text='" + this.text + '\'' + ", fontSize=" + this.fontSize + ", color=" + this.color + '}';
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

