/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders.additional;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import wf.core.game_engine.graphic.components.models.Line;
import wf.core.game_engine.graphic.components.models.Point;
import wf.core.game_engine.graphic.components.models.Ray;
import wf.core.game_engine.graphic.components.renders.ImageRender;
import wf.core.game_engine.graphic.components.renders.LineRender;
import wf.core.game_engine.graphic.components.renders.RayRender;
import wf.core.game_engine.graphic.interfaces.ComponentRender;
import wf.core.game_engine.graphic.utils.PosUtils;

public class CarRender
extends ImageRender
implements ComponentRender {
    private String name;
    private double speed;
    private double sensitivity;
    private double far;
    private LineRender[] lines = new LineRender[4];
    private RayRender[] ai_lines = new RayRender[8];
    private boolean rayFullRender;
    private boolean rayRender = true;
    private int rayWidth = 3;
    private Color rayColor = Color.WHITE;
    private boolean inGame = true;
    private Point spawnPoint;
    private double spawnRotation;
    private int ticks;

    public CarRender(String name, double speed, double sensitivity, ImageRender ri, boolean rayFullRender, int far) {
        super(ri.getImage(), ri.getX(), ri.getY(), ri.getWidth(), ri.getHeight(), ri.getRotate());
        this.name = name;
        this.speed = speed;
        this.sensitivity = sensitivity;
        this.spawnPoint = new Point(ri.getX(), ri.getY());
        this.spawnRotation = ri.getRotate();
        this.rayFullRender = rayFullRender;
        this.far = far;
    }

    public void setLines(int lineWidth) {
        AffineTransform af = AffineTransform.getTranslateInstance(this.getX(), this.getY());
        af.rotate(Math.toRadians(this.getRotate()), this.getWidth() / 2, this.getHeight() / 2);
        Point p1 = new Point(af.getTranslateX(), (int)af.getTranslateY());
        Point p2 = new Point(PosUtils.addX(af.getTranslateX(), 0.0, this.getHeight(), this.getRotate()), (int)PosUtils.addY(af.getTranslateY(), 0.0, this.getHeight(), this.getRotate()));
        Point p3 = new Point(PosUtils.addX(af.getTranslateX(), this.getWidth(), this.getHeight(), this.getRotate()), (int)PosUtils.addY(af.getTranslateY(), this.getWidth(), this.getHeight(), this.getRotate()));
        Point p4 = new Point(PosUtils.addX(af.getTranslateX(), this.getWidth(), 0.0, this.getRotate()), (int)PosUtils.addY(af.getTranslateY(), this.getWidth(), 0.0, this.getRotate()));
        this.lines[0] = new LineRender(new Line(p1, p2), Color.blue, lineWidth);
        this.lines[1] = new LineRender(new Line(p2, p3), Color.blue, lineWidth);
        this.lines[2] = new LineRender(new Line(p3, p4), Color.blue, lineWidth);
        this.lines[3] = new LineRender(new Line(p4, p1), Color.blue, lineWidth);
    }

    public void setAi_lines(Line[] lines) {
        Point p1 = new Point(this.getX() + (double)(this.getWidth() / 2), this.getY() + (double)(this.getHeight() / 2));
        this.ai_lines[0] = new RayRender(new Ray(p1, PosUtils.far(p1, this.far, this.getRotate() + 180.0), this.getRotate() + 180.0), this.rayColor, this.rayWidth, this.rayFullRender);
        this.ai_lines[1] = new RayRender(new Ray(p1, PosUtils.far(p1, this.far, this.getRotate() + 0.0), this.getRotate() + 0.0), this.rayColor, this.rayWidth, this.rayFullRender);
        this.ai_lines[2] = new RayRender(new Ray(p1, PosUtils.far(p1, this.far, this.getRotate() + 90.0), this.getRotate() + 90.0), this.rayColor, this.rayWidth, this.rayFullRender);
        this.ai_lines[3] = new RayRender(new Ray(p1, PosUtils.far(p1, this.far, this.getRotate() + 270.0), this.getRotate() + 270.0), this.rayColor, this.rayWidth, this.rayFullRender);
        this.ai_lines[4] = new RayRender(new Ray(p1, PosUtils.far(p1, this.far, this.getRotate() + 45.0), this.getRotate() + 45.0), this.rayColor, this.rayWidth, this.rayFullRender);
        this.ai_lines[5] = new RayRender(new Ray(p1, PosUtils.far(p1, this.far, this.getRotate() + 135.0), this.getRotate() + 135.0), this.rayColor, this.rayWidth, this.rayFullRender);
        this.ai_lines[6] = new RayRender(new Ray(p1, PosUtils.far(p1, this.far, this.getRotate() + 225.0), this.getRotate() + 225.0), this.rayColor, this.rayWidth, this.rayFullRender);
        this.ai_lines[7] = new RayRender(new Ray(p1, PosUtils.far(p1, this.far, this.getRotate() + 315.0), this.getRotate() + 315.0), this.rayColor, this.rayWidth, this.rayFullRender);
        for (RayRender ai_line : this.ai_lines) {
            ai_line.getRay().calculate(lines);
        }
    }

    public void moveForward() {
        this.setX(this.getX() - Math.cos(Math.toRadians(this.getRotate())) * this.speed);
        this.setY(this.getY() - Math.sin(Math.toRadians(this.getRotate())) * this.speed);
    }

    public void moveBack() {
        this.setX(this.getX() + Math.cos(Math.toRadians(this.getRotate())) * this.speed);
        this.setY(this.getY() + Math.sin(Math.toRadians(this.getRotate())) * this.speed);
    }

    public void rotateRight(double ins) {
        this.addRotate(this.sensitivity * ins);
    }

    public void rotateLeft(double ins) {
        this.addRotate(-(this.sensitivity * ins));
    }

    public void move(boolean[] keys) {
        if (keys[0]) {
            this.moveForward();
        }
        if (keys[1]) {
            this.moveBack();
        }
        if (keys[2]) {
            this.rotateLeft(1.0);
        }
        if (keys[3]) {
            this.rotateRight(1.0);
        }
    }

    public boolean isCollision(Line[] lines) {
        for (LineRender lr : this.lines) {
            for (Line l : lines) {
                if (!PosUtils.intersectsLines(lr.getLine(), l)) continue;
                return true;
            }
        }
        return false;
    }

    public void respawn() {
        this.setX(this.spawnPoint.getX());
        this.setY(this.spawnPoint.getY());
        this.setRotate(this.spawnRotation);
        this.inGame = true;
        this.ticks = 0;
    }

    public void respawn(Point p, double angle) {
        this.setX(p.getX());
        this.setY(p.getY());
        this.setRotate(angle);
        this.inGame = true;
    }

    public double[] getData() {
        double[] data = new double[this.ai_lines.length];
        for (int i = 0; i < this.ai_lines.length; ++i) {
            data[i] = this.ai_lines[i].getRay().getDistance() / this.far;
            if (this.ai_lines[i].getRay().getDistance() != -1.0) continue;
            data[i] = 1.0;
        }
        return data;
    }

    @Override
    public void render(Graphics g) {
        if (!this.isRender()) {
            return;
        }
        if (!this.inGame) {
            return;
        }
        if (this.ai_lines[0] != null && this.rayRender) {
            for (ComponentRender componentRender : this.ai_lines) {
                ((RayRender)componentRender).render(g);
            }
        }
        super.render(g);
        if (this.lines[0] != null) {
            for (ComponentRender componentRender : this.lines) {
                ((LineRender)componentRender).render(g);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    public double getFar() {
        return this.far;
    }

    public void setFar(double far) {
        this.far = far;
    }

    public LineRender[] getLines() {
        return this.lines;
    }

    public void setLines(LineRender[] lines) {
        this.lines = lines;
    }

    public RayRender[] getAi_lines() {
        return this.ai_lines;
    }

    public void setAi_lines(RayRender[] ai_lines) {
        this.ai_lines = ai_lines;
    }

    public boolean isRayFullRender() {
        return this.rayFullRender;
    }

    public void setRayFullRender(boolean rayFullRender) {
        this.rayFullRender = rayFullRender;
    }

    public boolean isRayRender() {
        return this.rayRender;
    }

    public void setRayRender(boolean rayRender) {
        this.rayRender = rayRender;
    }

    public int getRayWidth() {
        return this.rayWidth;
    }

    public void setRayWidth(int rayWidth) {
        this.rayWidth = rayWidth;
    }

    public Color getRayColor() {
        return this.rayColor;
    }

    public void setRayColor(Color rayColor) {
        this.rayColor = rayColor;
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public Point getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(Point spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    public double getSpawnRotation() {
        return this.spawnRotation;
    }

    public void setSpawnRotation(double spawnRotation) {
        this.spawnRotation = spawnRotation;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }
}

