/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.components.renders.additional;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Arrays;
import org.ejml.simple.SimpleMatrix;
import wf.core.game_engine.graphic.components.Component;
import wf.core.game_engine.graphic.components.models.Point;
import wf.core.game_engine.graphic.interfaces.ComponentRender;

public class NNRender
extends Component
implements ComponentRender {
    private SimpleMatrix[] weights;
    private Point[][] points;
    private double width;
    private double height;
    private double max;
    private double size;
    private double nnRenderMin = 0.0;
    private boolean autoResize = true;

    public NNRender(double x, double y, SimpleMatrix[] weights, double width, double height, double size) {
        super(x, y);
        this.weights = weights;
        this.width = width;
        this.height = height;
        this.size = size;
        for (int i = 0; i < weights.length; ++i) {
            this.max = (double)weights[i].numRows() > this.max ? (double)weights[i].numRows() : this.max;
            this.max = (double)weights[i].numCols() > this.max ? (double)weights[i].numCols() : this.max;
        }
    }

    public void calculate() {
        int i;
        if (this.autoResize) {
            for (SimpleMatrix weight : this.weights) {
                this.max = (double)weight.numRows() > this.max ? (double)weight.numRows() : this.max;
                this.max = (double)weight.numCols() > this.max ? (double)weight.numCols() : this.max;
            }
        }
        this.points = new Point[this.weights.length + 1][];
        for (i = 0; i < this.weights.length; ++i) {
            this.points[i] = new Point[this.weights[i].numCols()];
            if (i != this.weights.length - 1) continue;
            this.points[i + 1] = new Point[this.weights[i].numRows()];
        }
        for (i = 0; i < this.weights.length; ++i) {
            int j;
            for (j = 0; j < this.weights[i].numCols(); ++j) {
                this.points[i][j] = new Point(this.width / (double)this.weights.length * (double)i, (this.height * ((double)this.weights[i].numCols() / this.max) - (double)this.weights[i].numCols() * 5.0) / (double)this.weights[i].numCols() * (double)j + (this.height - this.height * ((double)this.weights[i].numCols() / this.max)) / 2.0);
            }
            if (i != this.weights.length - 1) continue;
            for (j = 0; j < this.weights[i].numRows(); ++j) {
                this.points[i + 1][j] = new Point(this.width, (this.height * ((double)this.weights[i].numRows() / this.max) - (double)this.weights[i].numRows() * 5.0) / (double)this.weights[i].numRows() * (double)j + (this.height - this.height * ((double)this.weights[i].numRows() / this.max)) / 2.0);
            }
        }
    }

    @Override
    public void render(Graphics g) {
        if (!this.isRender()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        try {
            for (int i = 0; i < this.points.length; ++i) {
                for (int j = 0; j < this.points[i].length; ++j) {
                    Point p = this.points[i][j];
                    if (i != this.points.length - 1) {
                        for (int d = 0; d < this.points[i + 1].length; ++d) {
                            Point p2 = this.points[i + 1][d];
                            double weight = this.weights[i].get(d, j);
                            double colorCoif = Math.min(Math.abs(weight) * 50.0, 255.0);
                            if (this.nnRenderMin > 0.05) {
                                colorCoif = 255.0;
                            }
                            g2.setStroke(new BasicStroke(1.0f));
                            if (weight > 0.0) {
                                g.setColor(new Color((int)colorCoif, 0, 0));
                            } else {
                                g.setColor(new Color(0, (int)colorCoif, 0));
                            }
                            if (!(weight < this.nnRenderMin && weight > -this.nnRenderMin) && !(this.nnRenderMin < 0.05)) continue;
                            g2.setStroke(new BasicStroke((float)((double)Math.round(1.0 / (1.0 + Math.pow(Math.E, -1.0 * Math.abs(weight))) * 4.0) / (15.0 / this.size))));
                            g.drawLine((int)(p.getX() + this.size / 2.0 + this.getX()), (int)(p.getY() + this.size / 2.0 + this.getY()), (int)(p2.getX() + this.size / 2.0 + this.getX()), (int)(p2.getY() + this.size / 2.0 + this.getY()));
                        }
                    }
                    g2.setStroke(new BasicStroke((int)this.size));
                    g.setColor(Color.WHITE);
                    g.drawOval((int)(p.getX() + this.getX()), (int)(p.getY() + this.getY()), (int)this.size, (int)this.size);
                    g.setColor(Color.black);
                    Font font = g.getFont().deriveFont((float)this.size * 1.5f);
                    g.setFont(font);
                    g.drawString(String.valueOf(j + 1), (int)(p.getX() + this.getX()), (int)(p.getY() + this.getY() + this.size));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "NNRender{weights=" + Arrays.toString(this.weights) + ", points=" + Arrays.toString((Object[])this.points) + ", width=" + this.width + ", height=" + this.height + ", max=" + this.max + ", size=" + this.size + ", x=" + this.getX() + ", y=" + this.getY() + ", nnRenderMin=" + this.nnRenderMin + ", autoResize=" + this.autoResize + '}';
    }

    public SimpleMatrix[] getWeights() {
        return this.weights;
    }

    public void setWeights(SimpleMatrix[] weights) {
        this.weights = weights;
    }

    public Point[][] getPoints() {
        return this.points;
    }

    public void setPoints(Point[][] points) {
        this.points = points;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public double getNnRenderMin() {
        return this.nnRenderMin;
    }

    public void setNnRenderMin(double nnRenderMin) {
        this.nnRenderMin = nnRenderMin;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }
}

