/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.graphic.utils;

import java.awt.geom.Line2D;
import wf.core.game_engine.graphic.components.models.Line;
import wf.core.game_engine.graphic.components.models.Point;

public class PosUtils {
    public static double addX(double oldX, double w, double h, double angle) {
        return oldX + (w * PosUtils.cos(angle) - h * PosUtils.sin(angle));
    }

    public static double addY(double oldY, double w, double h, double angle) {
        return oldY + (w * PosUtils.sin(angle) + h * PosUtils.cos(angle));
    }

    public static Point far(Point p1, double far, double angle) {
        return new Point(p1.getX() + PosUtils.cos(angle) * far, p1.getY() + PosUtils.sin(angle) * far);
    }

    public static double sin(double angle) {
        return Math.sin(Math.toRadians(angle));
    }

    public static double cos(double angle) {
        return Math.cos(Math.toRadians(angle));
    }

    public static Point positionAngle(double oldX, double oldY, double w, double h, double angle) {
        return new Point(PosUtils.addX(oldX, w, h, angle), PosUtils.addY(oldY, w, h, angle));
    }

    public static Point crossingPoint(Line l1, Line l2) {
        double x11 = l1.getP1().getX();
        double y11 = l1.getP1().getY();
        double x12 = l1.getP2().getX();
        double y12 = l1.getP2().getY();
        double x21 = l2.getP1().getX();
        double y21 = l2.getP1().getY();
        double x22 = l2.getP2().getX();
        double y22 = l2.getP2().getY();
        if (x11 == x12 && x21 == x22) {
            return null;
        }
        if (x11 == x12 || x21 == x22) {
            double b;
            double m;
            double x;
            if (x11 == x12) {
                x = x11;
                m = (y22 - y21) / (x22 - x21);
                b = (x22 * y21 - x21 * y22) / (x22 - x21);
            } else {
                x = x21;
                m = (y12 - y11) / (x12 - x11);
                b = (x12 * y11 - x11 * y12) / (x12 - x11);
            }
            double y = m * x + b;
            return new Point(x, y);
        }
        double m1 = (y12 - y11) / (x12 - x11);
        double b1 = (x12 * y11 - x11 * y12) / (x12 - x11);
        double m2 = (y22 - y21) / (x22 - x21);
        double b2 = (x22 * y21 - x21 * y22) / (x22 - x21);
        if (m1 == m2) {
            return null;
        }
        double x = (b2 - b1) / (m1 - m2);
        double y = m1 * x + b1;
        return new Point(x, y);
    }

    public static boolean intersectsLines(Line l1, Line l2) {
        return Line2D.linesIntersect(l1.getP1().getX(), l1.getP1().getY(), l1.getP2().getX(), l1.getP2().getY(), l2.getP1().getX(), l2.getP1().getY(), l2.getP2().getX(), l2.getP2().getY());
    }

    public static double getDistance(Point p1, Point p2) {
        return Math.sqrt((p2.getY() - p1.getY()) * (p2.getY() - p1.getY()) + (p2.getX() - p1.getX()) * (p2.getX() - p1.getX()));
    }

    public static int getNearestPointId(Point[] points, Point p) {
        int id = 0;
        double dist = PosUtils.getDistance(points[0], p);
        for (int i = 1; i < points.length; ++i) {
            double d = PosUtils.getDistance(points[i], p);
            if (!(d < dist)) continue;
            id = i;
            dist = d;
        }
        return id;
    }
}

