/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.neural_network.activationfunctions;

import org.ejml.simple.SimpleMatrix;
import wf.core.game_engine.neural_network.activationfunctions.ActivationFunction;

public class TanhActivationFunction
implements ActivationFunction {
    private static final String NAME = "TANH";

    @Override
    public SimpleMatrix applyActivationFunctionToMatrix(SimpleMatrix input) {
        SimpleMatrix output = new SimpleMatrix(input.numRows(), input.numCols());
        for (int i = 0; i < input.numRows(); ++i) {
            double value = input.get(i, 0);
            double result = Math.tanh(value);
            output.set(i, 0, result);
        }
        return output;
    }

    @Override
    public SimpleMatrix applyDerivativeOfActivationFunctionToMatrix(SimpleMatrix input) {
        SimpleMatrix output = new SimpleMatrix(input.numRows(), input.numCols());
        for (int i = 0; i < input.numRows(); ++i) {
            double value = input.get(i, 0);
            double result = 1.0 - value * value;
            output.set(i, 0, result);
        }
        return output;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

