/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.neural_network.utilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.ejml.data.Matrix;
import org.ejml.simple.SimpleOperations;
import wf.core.game_engine.neural_network.NeuralNetwork;
import wf.core.game_engine.neural_network.activationfunctions.ActivationFunction;
import wf.core.game_engine.neural_network.utilities.InterfaceAdapter;

public class FileReaderAndWriter {
    public static void writeToFile(NeuralNetwork nn, String fileName) {
        String name = fileName;
        if (fileName == null) {
            name = "nn_data";
        }
        try {
            FileWriter file = new FileWriter(name + ".json");
            Gson gson = FileReaderAndWriter.getGsonBuilder().create();
            String nnData = gson.toJson((Object)nn);
            file.write(nnData);
            file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NeuralNetwork readFromFile(String fileName) {
        NeuralNetwork nn = null;
        String name = fileName;
        if (fileName == null) {
            name = "nn_data.json";
        }
        try {
            Gson gson = FileReaderAndWriter.getGsonBuilder().create();
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(name));
            nn = (NeuralNetwork)gson.fromJson(jsonReader, NeuralNetwork.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nn;
    }

    private static GsonBuilder getGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ActivationFunction.class, new InterfaceAdapter());
        gsonBuilder.registerTypeAdapter(Matrix.class, new InterfaceAdapter());
        gsonBuilder.registerTypeAdapter(SimpleOperations.class, new InterfaceAdapter());
        gsonBuilder.setPrettyPrinting();
        return gsonBuilder;
    }
}

