/*
 * Decompiled with CFR 0.152.
 */
package wf.core.game_engine.neural_network.utilities;

import java.util.Random;
import org.ejml.simple.SimpleMatrix;
import wf.core.game_engine.neural_network.WrongDimensionException;

public class MatrixUtilities {
    public static SimpleMatrix arrayToMatrix(double[] i) {
        double[][] input = new double[][]{i};
        return (SimpleMatrix)new SimpleMatrix((double[][])input).transpose();
    }

    public static double[][] matrixTo2DArray(SimpleMatrix i) {
        double[][] result = new double[i.numRows()][i.numCols()];
        for (int j = 0; j < result.length; ++j) {
            for (int k = 0; k < result[0].length; ++k) {
                result[j][k] = i.get(j, k);
            }
        }
        return result;
    }

    public static double[] getColumnFromMatrixAsArray(SimpleMatrix data, int column) {
        double[] result = new double[data.numRows()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data.get(i, column);
        }
        return result;
    }

    public static SimpleMatrix mergeMatrices(SimpleMatrix matrixA, SimpleMatrix matrixB, double probability) {
        if (matrixA.numCols() != matrixB.numCols() || matrixA.numRows() != matrixB.numRows()) {
            throw new WrongDimensionException();
        }
        Random random = new Random();
        SimpleMatrix result = new SimpleMatrix(matrixA.numRows(), matrixA.numCols());
        for (int i = 0; i < matrixA.getNumElements(); ++i) {
            if (random.nextDouble() > probability) {
                result.set(i, matrixA.get(i));
                continue;
            }
            result.set(i, matrixB.get(i));
        }
        return result;
    }
}

