/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.springjdk17;

import io.github.xanthic.cache.api.Cache;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;

public class XanthicSpringCache
extends AbstractValueAdaptingCache {
    private final String name;
    private final Cache<Object, Object> cache;

    public XanthicSpringCache(String name, Cache<Object, Object> cache) {
        super(true);
        this.name = name;
        this.cache = cache;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Object getNativeCache() {
        return this.cache;
    }

    public <T> T get(@NotNull Object key, @NotNull Callable<T> valueLoader) {
        return (T)this.cache.computeIfAbsent(key, k -> this.getSynchronized(key, valueLoader));
    }

    private synchronized <T> T getSynchronized(Object key, Callable<T> valueLoader) {
        T value;
        Cache.ValueWrapper result = this.get(key);
        if (result != null) {
            return (T)result.get();
        }
        try {
            value = valueLoader.call();
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
        return value;
    }

    public void put(@NotNull Object key, Object value) {
        this.cache.put(key, this.toStoreValue(value));
    }

    public void evict(@NotNull Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    protected Object lookup(@NotNull Object key) {
        return this.cache.get(key);
    }
}

