/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import io.github.zero88.exceptions.FileException;
import io.github.zero88.repl.Reflections;
import io.github.zero88.utils.Strings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static Path getUserHomePath(@NotNull String directory) {
        return Paths.get(System.getProperty("user.home"), directory);
    }

    public static URL toUrl(String urlString) {
        if (Strings.isNotBlank(urlString)) {
            try {
                return new URL(urlString);
            }
            catch (MalformedURLException e) {
                logger.debug("Invalid parse URL from " + urlString, (Throwable)e);
            }
        }
        return null;
    }

    public static String readFileToString(String filePath) {
        String string;
        block8: {
            Path path = FileUtils.toPath(filePath);
            Stream<String> stream = Files.lines(path, StandardCharsets.UTF_8);
            try {
                string = stream.collect(Collectors.joining("\n"));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileException("Error when reading file: " + filePath, (Throwable)e);
                }
            }
            stream.close();
        }
        return string;
    }

    public static String getFileName(URL fileUrl) {
        try {
            return Paths.get(Objects.requireNonNull(fileUrl).toURI()).getFileName().toString();
        }
        catch (URISyntaxException | FileSystemNotFoundException e) {
            throw new FileException("File URL is wrong syntax", (Throwable)e);
        }
    }

    public static Path toPath(String filePath, String classpathFile) {
        return Strings.isBlank(filePath) ? FileUtils.getClasspathFile(classpathFile) : FileUtils.toPath(filePath);
    }

    private static Path getClasspathFile(String classpathFile) {
        Path fileInWorkingDir = Paths.get(".", classpathFile);
        if (fileInWorkingDir.toFile().exists()) {
            return fileInWorkingDir;
        }
        logger.debug("Not found in working dir. Try to get file {} in classloader", (Object)classpathFile);
        URL resource = Reflections.staticClassLoader().getResource(Strings.requireNotBlank(classpathFile));
        if (Objects.isNull(resource)) {
            logger.debug("File not found {}", (Object)classpathFile);
            throw new FileException("File not found " + classpathFile);
        }
        try {
            return Paths.get(resource.toURI());
        }
        catch (URISyntaxException ex) {
            throw new FileException(ex);
        }
    }

    public static Path toPath(String filePath) {
        try {
            return Paths.get(URI.create(filePath));
        }
        catch (IllegalArgumentException | SecurityException | FileSystemNotFoundException ex) {
            String strPath = Strings.requireNotBlank(filePath);
            strPath = strPath.replaceFirst("^(?:file:/)([^/])", "/".equals(File.separator) ? "/$1" : "$1");
            if (logger.isTraceEnabled()) {
                logger.trace("Invalid parse URI: " + strPath + ". Try to parse plain text", (Throwable)ex);
            }
            try {
                return Paths.get(strPath, new String[0]);
            }
            catch (InvalidPathException ex1) {
                ex1.addSuppressed(ex);
                throw new FileException("Cannot parse file path: " + filePath, (Throwable)ex1);
            }
        }
    }

    public static InputStream toStream(URL url) {
        try {
            return Objects.requireNonNull(url).openStream();
        }
        catch (IOException e) {
            throw new FileException("Cannot open stream via url: " + url.toString(), (Throwable)e);
        }
    }

    public static InputStream toStream(File file) {
        try {
            return new FileInputStream(Objects.requireNonNull(file));
        }
        catch (FileNotFoundException e) {
            throw new FileException("File not found: " + file.toString(), (Throwable)e);
        }
    }

    public static byte[] convertToBytes(InputStream inputStream) {
        return FileUtils.convertToByteArray(inputStream).toByteArray();
    }

    public static <T extends OutputStream> T writeToOutputStream(InputStream inputStream, T outputStream) {
        Objects.requireNonNull(outputStream, "Output stream is null");
        Objects.requireNonNull(inputStream, "Input stream is null");
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.flush();
            T t = outputStream;
            return t;
        }
        catch (IOException e) {
            throw new FileException("Error when writing stream", (Throwable)e);
        }
        finally {
            FileUtils.silentClose(inputStream);
        }
    }

    public static void silentClose(Closeable stream) {
        block3: {
            if (Objects.isNull(stream)) {
                return;
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace("Cannot close stream", (Throwable)e);
            }
        }
    }

    static ByteArrayOutputStream convertToByteArray(InputStream inputStream) {
        return FileUtils.writeToOutputStream(inputStream, new ByteArrayOutputStream());
    }

    public static String createFolder(Path defaultDataDir, String parentDir, String ... paths) {
        Path path = FileUtils.resolveDataFolder(defaultDataDir, parentDir);
        Path[] ps = new Path[]{path};
        Arrays.stream(paths).filter(Strings::isNotBlank).forEach(p -> {
            ps[0] = ps[0].resolve((String)p);
        });
        path = ps[0];
        File folder = path.toFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new FileException("Cannot create folder with path: " + path.toString());
        }
        return path.toAbsolutePath().toString();
    }

    public static Path resolveDataFolder(@NotNull Path defaultDataDir, String dir) {
        if (Strings.isNotBlank(dir)) {
            Path path = FileUtils.toPath(dir);
            return path.isAbsolute() ? path : defaultDataDir.resolve(dir);
        }
        return defaultDataDir;
    }

    public static boolean isChild(@NotNull Path parent, @NotNull Path child) {
        return child.toAbsolutePath().startsWith(parent);
    }

    public static String normalize(@NotNull String fileName) {
        return fileName.replaceAll("[\\\\:*?\"<>|]", "_").replaceAll("_+", "_");
    }

    public static Path recomputeDataDir(@NotNull Path defaultDataDir, @NotNull Path dataDir, @NotNull String resolvePath) {
        Path path = FileUtils.toPath(resolvePath);
        if (!path.isAbsolute()) {
            return dataDir.resolve(FileUtils.normalize(resolvePath));
        }
        if (FileUtils.isChild(defaultDataDir, path)) {
            if (defaultDataDir.equals(dataDir)) {
                return path;
            }
            return dataDir.resolve(defaultDataDir.relativize(path).toString().replaceAll("^/", ""));
        }
        return path;
    }

    public static String getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1)).orElse("");
    }
}

