/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import pl.edu.icm.unity.engine.api.authn.AuthenticatedEntity;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.AuthenticationStepContext;
import pl.edu.icm.unity.engine.api.authn.PartialAuthnState;
import pl.edu.icm.unity.engine.api.authn.RememberMeToken;
import pl.edu.icm.unity.engine.api.authn.RemoteAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.sandbox.SandboxAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.sandbox.SandboxAuthnRouter;
import pl.edu.icm.unity.engine.api.session.SessionParticipant;
import pl.edu.icm.unity.types.authn.AuthenticationOptionKey;
import pl.edu.icm.unity.types.authn.AuthenticationRealm;

public interface InteractiveAuthenticationProcessor {
    public PostAuthenticationStepDecision processFirstFactorResult(AuthenticationResult var1, AuthenticationStepContext var2, RememberMeToken.LoginMachineDetails var3, boolean var4, HttpServletRequest var5, HttpServletResponse var6, SessionReinitializer var7);

    public PostAuthenticationStepDecision processSecondFactorResult(PartialAuthnState var1, AuthenticationResult var2, AuthenticationStepContext var3, RememberMeToken.LoginMachineDetails var4, boolean var5, HttpServletRequest var6, HttpServletResponse var7, SessionReinitializer var8);

    public PostAuthenticationStepDecision processRemoteRegistrationResult(AuthenticationResult var1, AuthenticationStepContext var2, RememberMeToken.LoginMachineDetails var3, HttpServletRequest var4);

    public PostAuthenticationStepDecision processFirstFactorSandboxAuthnResult(SandboxAuthenticationResult var1, AuthenticationStepContext var2, RememberMeToken.LoginMachineDetails var3, HttpServletRequest var4, SandboxAuthnRouter var5);

    public PostAuthenticationStepDecision processSecondFactorSandboxAuthnResult(PartialAuthnState var1, SandboxAuthenticationResult var2, AuthenticationStepContext var3, RememberMeToken.LoginMachineDetails var4, HttpServletRequest var5, SandboxAuthnRouter var6);

    public void syntheticAuthenticate(AuthenticatedEntity var1, List<SessionParticipant> var2, AuthenticationOptionKey var3, AuthenticationRealm var4, RememberMeToken.LoginMachineDetails var5, boolean var6, HttpServletResponse var7, SessionReinitializer var8);

    public static class PostAuthenticationStepDecision {
        private final Decision decision;
        private final UnknownRemoteUserDetail unknownRemoteUserDetail;
        private final ErrorDetail errorDetail;
        private final SecondFactorDetail secondFactorDetail;

        private PostAuthenticationStepDecision(Decision decision, UnknownRemoteUserDetail unknownRemoteUserDetail, ErrorDetail errorDetail, SecondFactorDetail secondFactorDetail) {
            this.decision = decision;
            this.unknownRemoteUserDetail = unknownRemoteUserDetail;
            this.errorDetail = errorDetail;
            this.secondFactorDetail = secondFactorDetail;
        }

        public static PostAuthenticationStepDecision unknownRemoteUser(UnknownRemoteUserDetail unknownRemoteUserDetail) {
            return new PostAuthenticationStepDecision(Decision.UNKNOWN_REMOTE_USER, unknownRemoteUserDetail, null, null);
        }

        public static PostAuthenticationStepDecision error(ErrorDetail errorDetail) {
            return new PostAuthenticationStepDecision(Decision.ERROR, null, errorDetail, null);
        }

        public static PostAuthenticationStepDecision goToSecondFactor(SecondFactorDetail secondFactorDetail) {
            return new PostAuthenticationStepDecision(Decision.GO_TO_2ND_FACTOR, null, null, secondFactorDetail);
        }

        public static PostAuthenticationStepDecision completed() {
            return new PostAuthenticationStepDecision(Decision.COMPLETED, null, null, null);
        }

        public Decision getDecision() {
            return this.decision;
        }

        public UnknownRemoteUserDetail getUnknownRemoteUserDetail() {
            if (this.decision != Decision.UNKNOWN_REMOTE_USER) {
                throw new IllegalStateException("Unknown remote user detail not available in state: " + this.decision);
            }
            return this.unknownRemoteUserDetail;
        }

        public ErrorDetail getErrorDetail() {
            if (this.decision != Decision.ERROR) {
                throw new IllegalStateException("Error detail not available in state: " + this.decision);
            }
            return this.errorDetail;
        }

        public SecondFactorDetail getSecondFactorDetail() {
            if (this.decision != Decision.GO_TO_2ND_FACTOR) {
                throw new IllegalStateException("2nd factor detail not available in state: " + this.decision);
            }
            return this.secondFactorDetail;
        }

        public static class SecondFactorDetail {
            public final PartialAuthnState postFirstFactorResult;

            public SecondFactorDetail(PartialAuthnState postFirstFactorResult) {
                this.postFirstFactorResult = postFirstFactorResult;
            }
        }

        public static class ErrorDetail {
            public final AuthenticationResult.ResolvableError error;

            public ErrorDetail(AuthenticationResult.ResolvableError error) {
                this.error = error;
            }
        }

        public static class UnknownRemoteUserDetail {
            public final RemoteAuthenticationResult.UnknownRemotePrincipalResult unknownRemotePrincipal;

            public UnknownRemoteUserDetail(RemoteAuthenticationResult.UnknownRemotePrincipalResult unknownRemotePrincipal) {
                this.unknownRemotePrincipal = unknownRemotePrincipal;
            }
        }

        public static enum Decision {
            COMPLETED,
            GO_TO_2ND_FACTOR,
            ERROR,
            UNKNOWN_REMOTE_USER;

        }
    }

    public static interface SessionReinitializer {
        public HttpSession reinitialize();
    }
}

