/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import eu.unicore.util.configuration.ConfigurationException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import pl.edu.icm.unity.engine.api.authn.AbstractVerificator;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.RemoteAuthenticationException;
import pl.edu.icm.unity.engine.api.authn.RemoteAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAuthnResultTranslator;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.config.UnityPropertiesHelper;
import pl.edu.icm.unity.engine.api.translation.TranslationProfileGenerator;
import pl.edu.icm.unity.types.authn.IdPInfo;
import pl.edu.icm.unity.types.translation.TranslationProfile;

public abstract class AbstractRemoteVerificator
extends AbstractVerificator {
    private RemoteAuthnResultTranslator translator;

    public AbstractRemoteVerificator(String name, String description, String exchangeId, RemoteAuthnResultTranslator translator) {
        super(name, description, exchangeId);
        this.translator = translator;
    }

    protected RemoteAuthenticationResult getResultForNonInteractiveAuthn(RemotelyAuthenticatedInput input, TranslationProfile profile) throws RemoteAuthenticationException {
        return this.getResult(input, profile, false, null, false);
    }

    protected RemoteAuthenticationResult getResult(RemotelyAuthenticatedInput input, TranslationProfile profile, boolean sandboxMode, String registrationForm, boolean allowAssociation) throws RemoteAuthenticationException {
        return this.translator.getTranslatedResult(input, profile, sandboxMode, Optional.empty(), registrationForm, allowAssociation);
    }

    public static TranslationProfile getTranslationProfile(UnityPropertiesHelper props, String globalProfileNameKey, String embeddedProfileKey) throws ConfigurationException {
        if (props.isSet(embeddedProfileKey)) {
            return TranslationProfileGenerator.getProfileFromString(props.getValue(embeddedProfileKey));
        }
        if (props.getValue(globalProfileNameKey) != null) {
            return TranslationProfileGenerator.generateIncludeInputProfile(props.getValue(globalProfileNameKey));
        }
        throw new ConfigurationException("Translation profile is not set");
    }

    protected AuthenticationResult addGenericMessageIfError(RemoteAuthenticationResult result, AuthenticationResult.ResolvableError errorMessage) {
        if (result.getStatus() == AuthenticationResult.Status.deny && result.asRemote().getErrorResult().error == null) {
            return RemoteAuthenticationResult.failed(result.asRemote().getErrorResult().remotePrincipal, errorMessage);
        }
        return result;
    }

    public List<IdPInfo> getIdPs() {
        return Collections.emptyList();
    }
}

