/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pl.edu.icm.unity.engine.api.authn.remote.RelayedAuthnState;

public class RemoteAuthenticationContextManagement<T extends RelayedAuthnState> {
    public static final long MAX_TTL = 54000000L;
    public static final long CLEANUP_INTERVAL = 3600000L;
    private Map<String, T> contexts = new HashMap<String, T>();
    private Date lastCleanup = new Date();

    public synchronized void addAuthnContext(T context) {
        this.cleanup();
        String relayState = ((RelayedAuthnState)context).getRelayState();
        if (this.contexts.containsKey(relayState)) {
            throw new IllegalArgumentException("Ups, the relay state " + relayState + " is already assigned");
        }
        this.contexts.put(relayState, context);
    }

    public synchronized T getAuthnContext(String relayState) {
        this.cleanup();
        RelayedAuthnState ret = (RelayedAuthnState)this.contexts.get(relayState);
        if (ret == null) {
            throw new UnboundRelayStateException(relayState);
        }
        return (T)ret;
    }

    public synchronized void removeAuthnContext(String relayState) {
        this.contexts.remove(relayState);
    }

    private void cleanup() {
        long now = System.currentTimeMillis();
        if (new Date(now - 3600000L).before(this.lastCleanup)) {
            return;
        }
        this.lastCleanup = new Date(now);
        Date oldestAllowed = new Date(now - 54000000L);
        Iterator<T> it = this.contexts.values().iterator();
        while (it.hasNext()) {
            RelayedAuthnState ctx = (RelayedAuthnState)it.next();
            if (!ctx.getCreationTime().before(oldestAllowed)) continue;
            it.remove();
        }
    }

    public static class UnboundRelayStateException
    extends RuntimeException {
        public UnboundRelayStateException(String relayState) {
            super("The relay state " + relayState + " is not assigned");
        }
    }
}

