/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.translation.in;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAttribute;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteIdentity;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.translation.in.InputTranslationMVELContextKey;

public class InputTranslationContextFactory {
    public static Map<String, Object> createMvelContext(RemotelyAuthenticatedInput input) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(InputTranslationMVELContextKey.idp.name(), input.getIdpName());
        HashMap<String, String> attr = new HashMap<String, String>();
        HashMap<String, List<Object>> attrs = new HashMap<String, List<Object>>();
        for (RemoteAttribute ra : input.getAttributes().values()) {
            String v = ra.getValues().isEmpty() ? "" : ra.getValues().get(0);
            attr.put(ra.getName(), v);
            attrs.put(ra.getName(), ra.getValues());
        }
        ret.put(InputTranslationMVELContextKey.attr.name(), attr);
        ret.put(InputTranslationMVELContextKey.attrs.name(), attrs);
        ret.put(InputTranslationMVELContextKey.attrObj.name(), input.getRawAttributes());
        if (!input.getIdentities().isEmpty()) {
            RemoteIdentity ri = input.getIdentities().values().iterator().next();
            ret.put(InputTranslationMVELContextKey.id.name(), ri.getName());
            ret.put(InputTranslationMVELContextKey.idType.name(), ri.getIdentityType());
        } else {
            ret.put(InputTranslationMVELContextKey.id.name(), null);
            ret.put(InputTranslationMVELContextKey.idType.name(), null);
        }
        HashMap<String, ArrayList<String>> idsByType = new HashMap<String, ArrayList<String>>();
        for (RemoteIdentity ri : input.getIdentities().values()) {
            ArrayList<String> vals = (ArrayList<String>)idsByType.get(ri.getIdentityType());
            if (vals == null) {
                vals = new ArrayList<String>();
                idsByType.put(ri.getIdentityType(), vals);
            }
            vals.add(ri.getName());
        }
        ret.put(InputTranslationMVELContextKey.idsByType.name(), idsByType);
        ret.put(InputTranslationMVELContextKey.groups.name(), new ArrayList<String>(input.getGroups().keySet()));
        return ret;
    }

    public static Map<String, String> createExpresionValueMap(RemotelyAuthenticatedInput input) {
        Map<String, Object> mvelCtx = InputTranslationContextFactory.createMvelContext(input);
        return InputTranslationContextFactory.createExpresionValueMap(mvelCtx);
    }

    private static Map<String, String> createExpresionValueMap(Map<String, Object> mvelCtx) {
        LinkedHashMap<String, String> exprValMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> context : mvelCtx.entrySet()) {
            String contextKey = context.getKey();
            Object contextValue = context.getValue();
            try {
                InputTranslationMVELContextKey.valueOf(contextKey);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Incorrect MVEL context, unknown context key: " + context.getKey());
            }
            if (InputTranslationMVELContextKey.valueOf(contextKey) == InputTranslationMVELContextKey.attrObj) continue;
            if (contextValue instanceof Map) {
                HashMap value = (HashMap)contextValue;
                for (Map.Entry entry : value.entrySet()) {
                    if (entry.getValue() == null) continue;
                    exprValMap.put(String.format("%s['%s']", contextKey, entry.getKey()), entry.getValue().toString());
                }
                continue;
            }
            if (contextValue instanceof List) {
                exprValMap.put(contextKey, contextValue.toString());
                continue;
            }
            if (contextValue instanceof String) {
                exprValMap.put(contextKey, contextValue.toString());
                continue;
            }
            throw new IllegalArgumentException("Incorrect MVEL context: unexpected: \"" + contextValue.getClass() + "\" type for context key: \"" + contextKey + "\"");
        }
        return exprValMap;
    }
}

