/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.utils;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HiddenResourcesFilter
implements Filter {
    private List<String> protectedServletPaths;

    public HiddenResourcesFilter(List<String> protectedServletPaths) {
        this.protectedServletPaths = protectedServletPaths;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String servletPath = httpRequest.getServletPath();
        if (HiddenResourcesFilter.hasPathPrefix(servletPath, this.protectedServletPaths)) {
            httpResponse.sendError(404, "The requested address is not available.");
            return;
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public static boolean hasPathPrefix(String pathInfo, List<String> prefixes) {
        for (String prefix : prefixes) {
            if (!HiddenResourcesFilter.hasPathPrefix(pathInfo, prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPathPrefix(String pathInfo, String prefix) {
        if (pathInfo == null || pathInfo.equals("")) {
            return false;
        }
        if (!((String)prefix).startsWith("/")) {
            prefix = "/" + (String)prefix;
        }
        return pathInfo.startsWith((String)prefix);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void addProtectedPath(String path) {
        this.protectedServletPaths.add(path);
    }
}

