/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.attributes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pl.edu.icm.unity.base.attribute.AttributeType;
import pl.edu.icm.unity.base.attribute.AttributesClass;
import pl.edu.icm.unity.engine.api.exceptions.IllegalTypeException;
import pl.edu.icm.unity.engine.api.exceptions.RuntimeEngineException;
import pl.edu.icm.unity.engine.api.exceptions.SchemaConsistencyException;

public class AttributeClassHelper {
    public static final int MAX_CLASSES_PER_ENTITY = 20;
    private Map<String, AttributesClass> allClasses;
    private AttributesClass effectiveClass;

    public AttributeClassHelper() {
        this.effectiveClass = new AttributesClass("", "", new HashSet(0), new HashSet(0), true, new HashSet(0));
    }

    public AttributeClassHelper(Map<String, AttributesClass> knownClasses, Collection<String> assignedClasses) {
        if (assignedClasses.size() > 20) {
            throw new RuntimeEngineException("Maximum number of attribute classes assigned to entity is 20");
        }
        this.allClasses = knownClasses;
        this.effectiveClass = new AttributesClass();
        for (String assignedClass : assignedClasses) {
            AttributesClass existing = this.allClasses.get(assignedClass);
            if (existing == null) {
                throw new RuntimeEngineException("The attribute class " + assignedClass + " is not defined");
            }
            this.addAllFromClass(existing, this.effectiveClass);
        }
        if (assignedClasses.isEmpty()) {
            this.effectiveClass.setAllowArbitrary(true);
        }
    }

    public static void cleanupClass(AttributesClass toCleanup, Map<String, AttributesClass> knownClasses) throws IllegalTypeException {
        if (toCleanup.getParentClasses().isEmpty()) {
            return;
        }
        AttributeClassHelper.cleanupParents(toCleanup, knownClasses);
        AttributeClassHelper helper = new AttributeClassHelper(knownClasses, toCleanup.getParentClasses());
        if (helper.isEffectiveAllowArbitrary()) {
            toCleanup.getAllowed().clear();
            toCleanup.setAllowArbitrary(true);
        } else {
            AttributeClassHelper.removeIncluded(toCleanup.getAllowed(), helper, true);
        }
        AttributeClassHelper.removeIncluded(toCleanup.getMandatory(), helper, false);
    }

    public boolean isRestricting(AttributeClassHelper original) {
        if (!original.getEffectiveMandatory().containsAll(this.getEffectiveMandatory())) {
            return true;
        }
        if (this.isEffectiveAllowArbitrary()) {
            return false;
        }
        return !this.getEffectiveAllowed().containsAll(original.getEffectiveAllowed());
    }

    private static void removeIncluded(Set<String> set, AttributeClassHelper helper, boolean mode) {
        Iterator<String> aIt = set.iterator();
        while (aIt.hasNext()) {
            String a = aIt.next();
            if (!(mode ? helper.isAllowed(a) : helper.isMandatory(a))) continue;
            aIt.remove();
        }
    }

    private static void cleanupParents(AttributesClass toCleanup, Map<String, AttributesClass> knownClasses) {
        Set parentsToClean = toCleanup.getParentClasses();
        HashSet cleanedParents = new HashSet(parentsToClean);
        for (String p : parentsToClean) {
            HashSet<String> includedParents = new HashSet<String>();
            AttributeClassHelper.getAllParentsRec(p, knownClasses, includedParents);
            cleanedParents.removeAll(includedParents);
        }
        toCleanup.setParentClasses(cleanedParents);
    }

    private static void getAllParentsRec(String from, Map<String, AttributesClass> knownClasses, Set<String> ret) {
        Set parents = knownClasses.get(from).getParentClasses();
        ret.addAll(parents);
        for (String p : parents) {
            AttributeClassHelper.getAllParentsRec(p, knownClasses, ret);
        }
    }

    private void addAllFromClass(AttributesClass clazz, AttributesClass effective) {
        effective.getMandatory().addAll(clazz.getMandatory());
        effective.getAllowed().addAll(clazz.getAllowed());
        if (clazz.isAllowArbitrary()) {
            effective.setAllowArbitrary(true);
        }
        Set parents = clazz.getParentClasses();
        for (String parent : parents) {
            this.addAllFromClass(this.allClasses.get(parent), effective);
        }
    }

    public void checkAttribtues(Collection<String> attributes, Map<String, AttributeType> allTypes) throws SchemaConsistencyException {
        HashSet mandatory = new HashSet(this.effectiveClass.getMandatory());
        if (allTypes == null) {
            allTypes = Collections.emptyMap();
        }
        for (String name : attributes) {
            boolean system;
            AttributeType at = (AttributeType)allTypes.get(name);
            boolean bl = system = at == null ? false : at.isInstanceImmutable();
            if (!system && !this.effectiveClass.isAllowedDirectly(name)) {
                throw new SchemaConsistencyException("The assigned attribute " + name + " is not allowed by the attribute classes being assinged");
            }
            mandatory.remove(name);
        }
        if (mandatory.size() > 0) {
            throw new SchemaConsistencyException("The following attributes which are mandatory with respect to the attribute classes being assinged are not assigned: " + ((Object)mandatory).toString());
        }
    }

    public boolean isAllowed(String attribute) {
        return this.effectiveClass.isAllowedDirectly(attribute);
    }

    public boolean isMandatory(String attribute) {
        return this.effectiveClass.isMandatoryDirectly(attribute);
    }

    public Set<String> getEffectiveAllowed() {
        return this.effectiveClass.getAllowed();
    }

    public Set<String> getEffectiveMandatory() {
        return this.effectiveClass.getMandatory();
    }

    public boolean isEffectiveAllowArbitrary() {
        return this.effectiveClass.isAllowArbitrary();
    }
}

