/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pl.edu.icm.unity.base.authn.AuthenticationFlowDefinition;
import pl.edu.icm.unity.base.authn.AuthenticationPolicyConfiguration;
import pl.edu.icm.unity.base.exceptions.WrongArgumentException;
import pl.edu.icm.unity.engine.api.authn.AuthenticatorInstance;
import pl.edu.icm.unity.engine.api.authn.CredentialRetrieval;

public class AuthenticationFlow {
    private Set<AuthenticatorInstance> firstFactorAuthenticators;
    private List<AuthenticatorInstance> secondFactorAuthenticators;
    private AuthenticationFlowDefinition.Policy policy;
    private AuthenticationPolicyConfiguration policyConfiguration;
    private String name;
    private long revision;

    public AuthenticationFlow(String name, AuthenticationFlowDefinition.Policy policy, Set<AuthenticatorInstance> firstFactorAuthenticators, List<AuthenticatorInstance> secondFactorAuthenticators, AuthenticationPolicyConfiguration policyConfiguration, long revision) {
        this.name = name;
        this.policy = policy;
        this.firstFactorAuthenticators = firstFactorAuthenticators;
        this.secondFactorAuthenticators = secondFactorAuthenticators;
        this.policyConfiguration = policyConfiguration;
        this.revision = revision;
    }

    public String getId() {
        return this.name;
    }

    public Set<AuthenticatorInstance> getFirstFactorAuthenticators() {
        return this.firstFactorAuthenticators;
    }

    public List<AuthenticatorInstance> getSecondFactorAuthenticators() {
        return this.secondFactorAuthenticators;
    }

    public AuthenticationFlowDefinition.Policy getPolicy() {
        return this.policy;
    }

    public AuthenticationPolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    public void destroy() {
        for (AuthenticatorInstance firstFactor : this.firstFactorAuthenticators) {
            firstFactor.getRetrieval().destroy();
        }
        for (AuthenticatorInstance secondFactor : this.secondFactorAuthenticators) {
            secondFactor.getRetrieval().destroy();
        }
    }

    public Set<AuthenticatorInstance> getAllAuthenticators() {
        HashSet<AuthenticatorInstance> ret = new HashSet<AuthenticatorInstance>();
        ret.addAll(this.firstFactorAuthenticators);
        ret.addAll(this.secondFactorAuthenticators);
        return ret;
    }

    public long getRevision() {
        return this.revision;
    }

    public void checkIfAuthenticatorsAreAmongSupported(Set<String> supportedBindings) throws WrongArgumentException {
        this.checkIfAuthenticatorIsAmongSupported(this.firstFactorAuthenticators, supportedBindings);
        this.checkIfAuthenticatorIsAmongSupported(this.secondFactorAuthenticators, supportedBindings);
    }

    private void checkIfAuthenticatorIsAmongSupported(Collection<AuthenticatorInstance> authenticators, Set<String> supportedBindings) throws WrongArgumentException {
        for (AuthenticatorInstance authenticator : authenticators) {
            CredentialRetrieval authRet = authenticator.getRetrieval();
            if (supportedBindings.contains(authRet.getBindingName())) continue;
            throw new WrongArgumentException("The authenticator of type " + authRet.getBindingName() + " is not supported by the binding. Supported are: " + String.valueOf(supportedBindings));
        }
    }
}

