/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.edu.icm.unity.engine.api.authn.RemoteAuthnMetadata;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAttribute;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteGroupMembership;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteIdentity;
import pl.edu.icm.unity.engine.api.session.SessionParticipant;

public class RemotelyAuthenticatedInput {
    private String idpName;
    private Set<SessionParticipant> sessionParticipants = new HashSet<SessionParticipant>();
    private Map<String, RemoteGroupMembership> groups;
    private Map<String, RemoteAttribute> attributes;
    private Map<String, ? extends Object> rawAttributes;
    private Map<String, RemoteIdentity> identities;
    private RemoteAuthnMetadata remoteAuthnMetadata;
    private Instant authenticationTime;

    public RemotelyAuthenticatedInput(String idpName) {
        this.idpName = idpName;
        this.groups = new HashMap<String, RemoteGroupMembership>();
        this.attributes = new HashMap<String, RemoteAttribute>();
        this.rawAttributes = new HashMap<String, Object>();
        this.identities = new LinkedHashMap<String, RemoteIdentity>();
    }

    public String getIdpName() {
        return this.idpName;
    }

    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public void setGroups(List<RemoteGroupMembership> groups) {
        for (RemoteGroupMembership gm : groups) {
            this.groups.put(gm.getName(), gm);
        }
    }

    public void setAttributes(List<RemoteAttribute> attributes) {
        for (RemoteAttribute gm : attributes) {
            this.attributes.put(gm.getName(), gm);
        }
    }

    public void setIdentities(List<RemoteIdentity> identities) {
        for (RemoteIdentity gm : identities) {
            this.identities.put(gm.getName(), gm);
        }
    }

    public void addIdentity(RemoteIdentity gm) {
        this.identities.put(gm.getName(), gm);
    }

    public void addAttribute(RemoteAttribute attribute) {
        this.attributes.put(attribute.getName(), attribute);
    }

    public void addGroup(RemoteGroupMembership group) {
        this.groups.put(group.getName(), group);
    }

    public Map<String, RemoteGroupMembership> getGroups() {
        return this.groups;
    }

    public Map<String, RemoteAttribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, RemoteIdentity> getIdentities() {
        return this.identities;
    }

    public Set<SessionParticipant> getSessionParticipants() {
        return this.sessionParticipants;
    }

    public void addSessionParticipant(SessionParticipant sessionParticipant) {
        this.sessionParticipants.add(sessionParticipant);
    }

    public Map<String, ? extends Object> getRawAttributes() {
        return this.rawAttributes;
    }

    public void setRawAttributes(Map<String, ? extends Object> rawAttributes) {
        this.rawAttributes = rawAttributes;
    }

    public RemoteAuthnMetadata getRemoteAuthnMetadata() {
        return this.remoteAuthnMetadata;
    }

    public void setRemoteAuthnMetadata(RemoteAuthnMetadata authnContext) {
        this.remoteAuthnMetadata = authnContext;
    }

    public String toString() {
        return this.idpName;
    }

    public Instant getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Instant authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public String getTextDump() {
        StringBuilder sb = new StringBuilder();
        if (!this.identities.isEmpty()) {
            sb.append("Identities:\n");
            for (RemoteIdentity id : this.identities.values()) {
                sb.append(" - ").append(id).append("\n");
            }
        }
        if (!this.attributes.isEmpty()) {
            sb.append("Attributes:\n");
            for (RemoteAttribute at : this.attributes.values()) {
                sb.append(" - ").append(at).append("\n");
            }
        }
        if (!this.groups.isEmpty()) {
            sb.append("Groups:\n");
            for (RemoteGroupMembership gr : this.groups.values()) {
                sb.append(" - ").append(gr).append("\n");
            }
        }
        return sb.toString().trim();
    }
}

