/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.authn.remote;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import pl.edu.icm.unity.base.attribute.Attribute;
import pl.edu.icm.unity.base.entity.EntityParam;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.identity.IdentityTaV;
import pl.edu.icm.unity.engine.api.authn.InvocationContext;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.session.SessionParticipant;
import pl.edu.icm.unity.engine.api.translation.in.MappingResult;

public class RemotelyAuthenticatedPrincipal {
    private static final String NONE = "--none--";
    private String remoteIdPName;
    private String inputTranslationProfile;
    private Set<SessionParticipant> sessionParticipants;
    private Collection<IdentityTaV> identities = new ArrayList<IdentityTaV>();
    private EntityParam localMappedPrincipal;
    private Collection<Attribute> attributes = new ArrayList<Attribute>();
    private Collection<String> groups = new ArrayList<String>();
    private MappingResult mappingResult;
    private RemotelyAuthenticatedInput input;
    private Instant creationTime;

    public static RemotelyAuthenticatedPrincipal getLocalContext() {
        return new RemotelyAuthenticatedPrincipal(NONE, NONE);
    }

    public static boolean isLocalContext(RemotelyAuthenticatedPrincipal ctx) {
        return NONE.equals(ctx.getRemoteIdPName()) && NONE.equalsIgnoreCase(ctx.getInputTranslationProfile());
    }

    public RemotelyAuthenticatedPrincipal(String remoteIdPName, String inputTranslationProfile) {
        this.remoteIdPName = remoteIdPName;
        this.inputTranslationProfile = inputTranslationProfile;
        try {
            InvocationContext ctx = InvocationContext.getCurrent();
            if (ctx.getTlsIdentity() != null) {
                this.identities.add(ctx.getTlsIdentity());
            }
        }
        catch (InternalException internalException) {
            // empty catch block
        }
    }

    public Collection<IdentityTaV> getIdentities() {
        return this.identities;
    }

    public void addIdentities(Collection<IdentityTaV> identities) {
        this.identities.addAll(identities);
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttributes(Collection<Attribute> attributes) {
        this.attributes.addAll(attributes);
    }

    public Collection<String> getGroups() {
        return this.groups;
    }

    public void addGroups(Collection<String> groups) {
        this.groups.addAll(groups);
    }

    public EntityParam getLocalMappedPrincipal() {
        return this.localMappedPrincipal;
    }

    public void setLocalMappedPrincipal(EntityParam localMappedPrincipal) {
        this.localMappedPrincipal = localMappedPrincipal;
    }

    public String getRemoteIdPName() {
        return this.remoteIdPName;
    }

    public String getInputTranslationProfile() {
        return this.inputTranslationProfile;
    }

    public MappingResult getMappingResult() {
        return this.mappingResult;
    }

    public void setMappingResult(MappingResult mappingResult) {
        this.mappingResult = mappingResult;
    }

    public void setAuthnInput(RemotelyAuthenticatedInput input) {
        this.input = input;
    }

    public RemotelyAuthenticatedInput getAuthnInput() {
        return this.input;
    }

    public Set<SessionParticipant> getSessionParticipants() {
        return this.sessionParticipants;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    public void setSessionParticipants(Set<SessionParticipant> sessionParticipants) {
        this.sessionParticipants = new HashSet<SessionParticipant>();
        this.sessionParticipants.addAll(sessionParticipants);
    }

    public String toString() {
        return "RemotelyAuthenticatedContext [remoteIdPName=" + this.remoteIdPName + "\ninputTranslationProfile=" + this.inputTranslationProfile + "\nsessionParticipants=" + String.valueOf(this.sessionParticipants) + "\nidentities=" + String.valueOf(this.identities) + "\nlocalMappedPrincipal=" + String.valueOf(this.localMappedPrincipal) + "\nattributes=" + String.valueOf(this.attributes) + "\ngroups=" + String.valueOf(this.groups) + "\n***mappingResult=\n" + String.valueOf(this.mappingResult) + "\n***input:\n" + (this.input != null ? this.input.getTextDump() : "") + "\ncreationTime=" + String.valueOf(this.creationTime) + "]";
    }
}

