/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.confirmation.states;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.exceptions.WrongArgumentException;
import pl.edu.icm.unity.base.json.JsonUtil;

public class BaseEmailConfirmationState {
    protected final ObjectMapper mapper = Constants.MAPPER;
    protected String facilityId;
    protected String type;
    protected String value;
    protected String locale;

    public BaseEmailConfirmationState(String facilityId, String type, String value, String locale) {
        this.type = type;
        this.value = value;
        this.locale = locale;
        this.facilityId = facilityId;
    }

    public BaseEmailConfirmationState(String serializedState) throws WrongArgumentException {
        this.setSerializedConfiguration(serializedState);
    }

    protected BaseEmailConfirmationState() {
    }

    public String getFacilityId() {
        return this.facilityId;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getSerializedConfiguration() throws InternalException {
        return JsonUtil.serialize((JsonNode)this.createState());
    }

    protected ObjectNode createState() {
        ObjectNode state = this.mapper.createObjectNode();
        state.withObjectProperty("confirmationState");
        state.put("value", this.getValue());
        state.put("type", this.getType());
        state.put("facilityId", this.getFacilityId());
        state.put("locale", this.getLocale());
        return state;
    }

    protected void setSerializedConfiguration(String json) {
        this.setSerializedConfiguration(JsonUtil.parse((String)json));
    }

    protected void setSerializedConfiguration(ObjectNode main) {
        try {
            this.type = main.get("type").asText();
            this.value = main.get("value").asText();
            this.facilityId = main.get("facilityId").asText();
            this.locale = main.get("locale").asText();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't perform JSON deserialization", e);
        }
    }
}

