/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.enquiry;

import java.util.Objects;
import java.util.function.Predicate;
import pl.edu.icm.unity.base.registration.EnquiryForm;

public class EnquirySelector {
    public final Type type;
    public final AccessMode accessMode;

    private EnquirySelector(Builder builder) {
        this.type = builder.type;
        this.accessMode = builder.accessMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessMode, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnquirySelector other = (EnquirySelector)obj;
        return this.accessMode == other.accessMode && this.type == other.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Type type = Type.ALL;
        private AccessMode accessMode = AccessMode.ANY;

        private Builder() {
        }

        public Builder withType(Type type) {
            this.type = type;
            return this;
        }

        public Builder withAccessMode(AccessMode accessMode) {
            this.accessMode = accessMode;
            return this;
        }

        public EnquirySelector build() {
            return new EnquirySelector(this);
        }
    }

    public static enum Type {
        STICKY(f -> f.getType().equals((Object)EnquiryForm.EnquiryType.STICKY)),
        REGULAR(f -> f.getType().equals((Object)EnquiryForm.EnquiryType.REQUESTED_MANDATORY) || f.getType().equals((Object)EnquiryForm.EnquiryType.REQUESTED_OPTIONAL)),
        ALL(f -> true);

        public final Predicate<EnquiryForm> filter;

        private Type(Predicate<EnquiryForm> filter) {
            this.filter = filter;
        }
    }

    public static enum AccessMode {
        NOT_BY_INVITATION_ONLY(f -> !f.isByInvitationOnly()),
        ANY(f -> true);

        public final Predicate<EnquiryForm> filter;

        private AccessMode(Predicate<EnquiryForm> filter) {
            this.filter = filter;
        }
    }
}

