/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.msgtemplate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import pl.edu.icm.unity.base.i18n.I18nMessage;
import pl.edu.icm.unity.base.i18n.I18nString;
import pl.edu.icm.unity.base.msg_template.MessageTemplateDefinition;

public class MessageTemplateValidator {
    public static void validateMessage(MessageTemplateDefinition consumer, I18nMessage message) throws IllegalVariablesException, MandatoryVariablesException {
        I18nString subject = message.getSubject();
        for (String subjectL : subject.getMap().values()) {
            MessageTemplateValidator.validateText(consumer, subjectL, false);
        }
        I18nString body = message.getBody();
        for (String bodyL : body.getMap().values()) {
            MessageTemplateValidator.validateText(consumer, bodyL, true);
        }
    }

    public static Set<String> extractVariables(I18nMessage message) {
        HashSet<String> vars = new HashSet<String>();
        I18nString subject = message.getSubject();
        for (String subjectL : subject.getMap().values()) {
            vars.addAll(MessageTemplateValidator.extractVariables(subjectL));
        }
        vars.addAll(MessageTemplateValidator.extractVariables(subject.getDefaultValue()));
        I18nString body = message.getBody();
        for (String bodyL : body.getMap().values()) {
            vars.addAll(MessageTemplateValidator.extractVariables(bodyL));
        }
        vars.addAll(MessageTemplateValidator.extractVariables(body.getDefaultValue()));
        return vars;
    }

    public static Set<String> extractCustomVariables(I18nMessage message) {
        return MessageTemplateValidator.extractVariables(message).stream().filter(var -> var.startsWith("custom.")).collect(Collectors.toSet());
    }

    private static Set<String> extractVariables(String text) {
        if (text == null) {
            return Collections.emptySet();
        }
        Set<String> usedField = MessageTemplateValidator.extractVariables(text, "\\$\\{[^\\}]*\\}", 1);
        usedField.addAll(MessageTemplateValidator.extractVariables(text, "\\{\\{[^\\}]*\\}\\}", 2));
        return MessageTemplateValidator.filterDirectives(usedField);
    }

    private static Set<String> filterDirectives(Set<String> statements) {
        return statements.stream().filter(v -> !v.startsWith("include:")).collect(Collectors.toSet());
    }

    private static Set<String> extractVariables(String text, String patternStr, int suffixLen) {
        HashSet<String> usedField = new HashSet<String>();
        Pattern pattern = Pattern.compile(patternStr);
        String b = text;
        Matcher matcher = pattern.matcher(b);
        while (matcher.find()) {
            usedField.add(b.substring(matcher.start() + 2, matcher.end() - suffixLen));
        }
        return usedField;
    }

    public static void validateText(MessageTemplateDefinition consumer, String text, boolean checkMandatory) throws IllegalVariablesException, MandatoryVariablesException {
        Set<String> usedField = MessageTemplateValidator.extractVariables(text);
        HashSet<String> knownVariables = new HashSet<String>();
        HashSet<String> mandatory = new HashSet<String>();
        for (Object var2 : consumer.getVariables().values()) {
            knownVariables.add(var2.getName());
            if (!var2.isMandatory()) continue;
            mandatory.add(var2.getName());
        }
        HashSet<String> unknown = new HashSet<String>();
        for (String f : usedField) {
            if (knownVariables.contains(f)) continue;
            unknown.add(f);
        }
        if (!unknown.isEmpty()) {
            if (consumer.allowCustomVariables()) {
                boolean hasNonCustomUnnown = unknown.stream().filter(var -> !var.startsWith("custom.")).findAny().isPresent();
                if (hasNonCustomUnnown) {
                    throw new IllegalVariablesException(unknown);
                }
            } else {
                throw new IllegalVariablesException(unknown);
            }
        }
        if (!checkMandatory) {
            return;
        }
        HashSet<String> uman = new HashSet<String>();
        for (String m : mandatory) {
            if (usedField.contains(m)) continue;
            uman.add(m);
        }
        if (!uman.isEmpty()) {
            throw new MandatoryVariablesException(uman);
        }
    }

    public static class IllegalVariablesException
    extends Exception {
        private Collection<String> unknown;

        public IllegalVariablesException(Collection<String> unknown) {
            this.unknown = unknown;
        }

        public Collection<String> getUnknown() {
            return this.unknown;
        }
    }

    public static class MandatoryVariablesException
    extends Exception {
        private Collection<String> mandatory;

        public MandatoryVariablesException(Collection<String> mandatory) {
            this.mandatory = mandatory;
        }

        public Collection<String> getMandatory() {
            return this.mandatory;
        }
    }
}

