/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.mvel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pl.edu.icm.unity.base.group.Group;
import pl.edu.icm.unity.engine.api.mvel.MVELGroup;

public class CachingMVELGroupProvider {
    private final Map<String, MVELGroup> mvelGroupsByPathCache;

    public CachingMVELGroupProvider(Map<String, Group> groupsByPath) {
        this.mvelGroupsByPathCache = new HashMap<String, MVELGroup>(groupsByPath.size());
        ArrayList<String> groupPaths = new ArrayList<String>(groupsByPath.keySet());
        Collections.sort(groupPaths, (a, b) -> Integer.compare(a.length(), b.length()));
        Iterator iterator = groupPaths.iterator();
        while (iterator.hasNext()) {
            String path;
            Group group;
            String parentPath = (group = groupsByPath.get(path = (String)iterator.next())).getParentPath();
            this.mvelGroupsByPathCache.put(path, new MVELGroup(group, parentPath == null ? null : this.mvelGroupsByPathCache.get(parentPath)));
        }
    }

    public MVELGroup get(String groupPath) {
        MVELGroup ret = this.mvelGroupsByPathCache.get(groupPath);
        if (ret == null) {
            throw new IllegalArgumentException("No cached MVEL group for path " + groupPath);
        }
        return ret;
    }
}

