/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.mvel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mvel2.ast.FunctionInstance;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import pl.edu.icm.unity.base.attribute.AttributeStatement;
import pl.edu.icm.unity.base.group.Group;
import pl.edu.icm.unity.base.group.GroupDelegationConfiguration;
import pl.edu.icm.unity.base.group.GroupProperty;
import pl.edu.icm.unity.base.i18n.I18nString;
import pl.edu.icm.unity.base.message.MessageSource;
import pl.edu.icm.unity.engine.api.group.GroupsChain;

public class MVELGroup {
    private final Group group;
    private final MVELGroup parent;

    public MVELGroup(GroupsChain groupChain) {
        this(groupChain.getLast(), MVELGroup.getParentFromChain(groupChain));
    }

    public MVELGroup(Group group, MVELGroup parent) {
        this.group = group;
        this.parent = parent;
    }

    private static MVELGroup getParentFromChain(GroupsChain groupChain) {
        GroupsChain parentChain = groupChain.getParentChain();
        return parentChain == null ? null : new MVELGroup(parentChain);
    }

    public boolean isChild(MVELGroup test) {
        return this.group.isChild(test.group);
    }

    public boolean isChildNotSame(MVELGroup test) {
        return this.group.isChildNotSame(test.group);
    }

    public boolean isTopLevel() {
        return this.group.isTopLevel();
    }

    public String getPathEncoded() {
        return this.group.getPathEncoded();
    }

    public String getName() {
        return this.group.getName();
    }

    public I18nString getDisplayedNameShort(MessageSource msg) {
        return this.group.getDisplayedNameShort(msg);
    }

    public String getRelativeName() {
        return this.group.getRelativeName();
    }

    public String getParentPath() {
        return this.group.getParentPath();
    }

    public AttributeStatement[] getAttributeStatements() {
        return this.group.getAttributeStatements();
    }

    public Set<String> getAttributesClasses() {
        return this.group.getAttributesClasses();
    }

    public GroupDelegationConfiguration getDelegationConfiguration() {
        return this.group.getDelegationConfiguration();
    }

    public boolean isPublic() {
        return this.group.isPublic();
    }

    public String getNameShort() {
        return this.group.getNameShort();
    }

    public String toString() {
        return this.group.toString();
    }

    public I18nString getDescription() {
        return this.group.getDescription();
    }

    public I18nString getDisplayedName() {
        return this.group.getDisplayedName();
    }

    public Map<String, String> getProperties() {
        return this.group.getProperties().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((GroupProperty)e.getValue()).value));
    }

    public String getEncodedGroupPath(String delimiter, FunctionInstance lambda) {
        return this.getEncodedGroupPath(delimiter, 0, lambda);
    }

    public String getEncodedGroupPath(String delimiter, int initialParentsToSkip, FunctionInstance lambda) {
        HashMap<String, MVELGroup> var = new HashMap<String, MVELGroup>();
        var.put("group", this);
        Object[] group = new MVELGroup[]{this};
        if (this.parent == null || this.group.getPath().length <= initialParentsToSkip) {
            return (String)lambda.call(null, null, (VariableResolverFactory)new MapVariableResolverFactory(), group);
        }
        return this.parent.getEncodedGroupPath(delimiter, initialParentsToSkip, lambda) + delimiter + (String)lambda.call(null, null, (VariableResolverFactory)new MapVariableResolverFactory(), group);
    }
}

