/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.policyDocument;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import pl.edu.icm.unity.base.i18n.I18nString;
import pl.edu.icm.unity.base.policy_document.PolicyDocumentContentType;

public class PolicyDocumentCreateRequest {
    public final String name;
    public final I18nString displayedName;
    public final boolean mandatory;
    public final PolicyDocumentContentType contentType;
    public final I18nString content;

    public PolicyDocumentCreateRequest(String name, I18nString displayedName, boolean mandatory, PolicyDocumentContentType contentType, I18nString content) {
        this.name = name;
        this.displayedName = displayedName.clone();
        this.mandatory = mandatory;
        this.contentType = contentType;
        this.content = content.clone();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PolicyDocumentCreateRequest)) {
            return false;
        }
        PolicyDocumentCreateRequest castOther = (PolicyDocumentCreateRequest)other;
        return Objects.equals(this.name, castOther.name) && Objects.equals(this.displayedName, castOther.displayedName) && Objects.equals(this.content, castOther.content) && Objects.equals(this.contentType, castOther.contentType) && Objects.equals(this.mandatory, castOther.mandatory);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayedName, this.contentType, this.content, this.mandatory);
    }

    public static PolicyDocumentCreateRequestBuilder createRequestBuilder() {
        return new PolicyDocumentCreateRequestBuilder();
    }

    public static final class PolicyDocumentCreateRequestBuilder {
        private String name;
        private I18nString displayedName;
        private boolean mandatory;
        private PolicyDocumentContentType contentType;
        private I18nString content;

        private PolicyDocumentCreateRequestBuilder() {
        }

        public PolicyDocumentCreateRequestBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public PolicyDocumentCreateRequestBuilder withDisplayedName(Map<String, String> displayedName) {
            this.displayedName = new I18nString();
            this.displayedName.addAllValues(displayedName);
            Optional.ofNullable(displayedName.get("")).ifPresent(arg_0 -> ((I18nString)this.displayedName).setDefaultValue(arg_0));
            return this;
        }

        public PolicyDocumentCreateRequestBuilder withMandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public PolicyDocumentCreateRequestBuilder withContentType(String contentType) {
            this.contentType = PolicyDocumentContentType.valueOf((String)contentType);
            return this;
        }

        public PolicyDocumentCreateRequestBuilder withContent(Map<String, String> content) {
            this.content = new I18nString();
            this.content.addAllValues(content);
            Optional.ofNullable(content.get("")).ifPresent(arg_0 -> ((I18nString)this.content).setDefaultValue(arg_0));
            return this;
        }

        public PolicyDocumentCreateRequest build() {
            return new PolicyDocumentCreateRequest(this.name, this.displayedName, this.mandatory, this.contentType, this.content);
        }
    }
}

