/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.policyDocument;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import pl.edu.icm.unity.base.i18n.I18nString;
import pl.edu.icm.unity.base.policy_document.PolicyDocumentContentType;
import pl.edu.icm.unity.engine.api.policyDocument.PolicyDocumentCreateRequest;

public class PolicyDocumentUpdateRequest
extends PolicyDocumentCreateRequest {
    public final Long id;

    public PolicyDocumentUpdateRequest(Long id, String name, I18nString displayedName, boolean mandatory, PolicyDocumentContentType contentType, I18nString content) {
        super(name, displayedName, mandatory, contentType, content);
        this.id = id;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PolicyDocumentUpdateRequest)) {
            return false;
        }
        PolicyDocumentUpdateRequest castOther = (PolicyDocumentUpdateRequest)other;
        return Objects.equals(this.id, castOther.id) && Objects.equals(this.name, castOther.name) && Objects.equals(this.displayedName, castOther.displayedName) && Objects.equals(this.content, castOther.content) && Objects.equals(this.contentType, castOther.contentType) && Objects.equals(this.mandatory, castOther.mandatory);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.displayedName, this.contentType, this.content, this.mandatory);
    }

    public static PolicyDocumentUpdateRequestBuilder updateRequestBuilder() {
        return new PolicyDocumentUpdateRequestBuilder();
    }

    public static final class PolicyDocumentUpdateRequestBuilder {
        private Long id;
        private String name;
        private I18nString displayedName;
        private boolean mandatory;
        private PolicyDocumentContentType contentType;
        private I18nString content;

        private PolicyDocumentUpdateRequestBuilder() {
        }

        public PolicyDocumentUpdateRequestBuilder withId(Long id) {
            this.id = id;
            return this;
        }

        public PolicyDocumentUpdateRequestBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public PolicyDocumentUpdateRequestBuilder withDisplayedName(Map<String, String> displayedName) {
            this.displayedName = new I18nString();
            this.displayedName.addAllValues(displayedName);
            Optional.ofNullable(displayedName.get("")).ifPresent(arg_0 -> ((I18nString)this.displayedName).setDefaultValue(arg_0));
            return this;
        }

        public PolicyDocumentUpdateRequestBuilder withMandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public PolicyDocumentUpdateRequestBuilder withContentType(String contentType) {
            this.contentType = PolicyDocumentContentType.valueOf((String)contentType);
            return this;
        }

        public PolicyDocumentUpdateRequestBuilder withContent(Map<String, String> content) {
            this.content = new I18nString();
            this.content.addAllValues(content);
            Optional.ofNullable(content.get("")).ifPresent(arg_0 -> ((I18nString)this.content).setDefaultValue(arg_0));
            return this;
        }

        public PolicyDocumentUpdateRequest build() {
            return new PolicyDocumentUpdateRequest(this.id, this.name, this.displayedName, this.mandatory, this.contentType, this.content);
        }
    }
}

