/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.engine.api.project;

import com.google.common.base.Objects;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import pl.edu.icm.unity.base.verifiable.VerifiableElementBase;
import pl.edu.icm.unity.engine.api.project.ProjectRequestParam;
import pl.edu.icm.unity.engine.api.registration.RequestType;

public class ProjectRequest
extends ProjectRequestParam {
    public final String name;
    public final VerifiableElementBase email;
    public final List<String> groups;
    public final Instant requestedTime;

    public ProjectRequest(String id, ProjectRequestParam.RequestOperation operation, RequestType type, String project, String name, VerifiableElementBase email, Optional<List<String>> groups, Instant requestedTime) {
        super(project, id, operation, type);
        this.name = name;
        this.email = email;
        this.groups = !groups.isPresent() ? Collections.unmodifiableList(Collections.emptyList()) : Collections.unmodifiableList(groups.get());
        this.requestedTime = requestedTime;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.operation, this.type, this.project, this.name, this.email, this.groups, this.requestedTime});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectRequest other = (ProjectRequest)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equal((Object)this.email, (Object)other.email) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.groups, other.groups) && Objects.equal((Object)this.requestedTime, (Object)other.requestedTime);
    }
}

