/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import io.intercom.api.Admin;
import io.intercom.api.AdminMessage;
import io.intercom.api.AdminMessageResponse;
import io.intercom.api.AdminReply;
import io.intercom.api.AuthorizationException;
import io.intercom.api.ConversationCollection;
import io.intercom.api.ConversationMessage;
import io.intercom.api.ConversationPart;
import io.intercom.api.ConversationPartCollection;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import io.intercom.api.User;
import io.intercom.api.UserMessage;
import io.intercom.api.UserReply;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Conversation
extends TypedData {
    private static final HashMap<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    private final String type = "conversation";
    @JsonProperty
    private String id;
    @JsonProperty(value="conversation_message")
    private ConversationMessage conversationMessage;
    @JsonProperty(value="user")
    private User user;
    @JsonProperty(value="assignee")
    private Admin assignee;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty
    private ConversationPartCollection conversationPartCollection;
    @JsonProperty(value="open")
    private boolean open;
    @JsonProperty(value="read")
    private boolean read;
    @JsonProperty(value="links")
    private Map<String, URI> links;

    public static Conversation find(String id) throws InvalidException, AuthorizationException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("conversations").path(id).build());
        return resource.get(Conversation.class);
    }

    public static ConversationCollection list() throws InvalidException, AuthorizationException {
        return DataResource.list(SENTINEL, "conversations", ConversationCollection.class);
    }

    public static ConversationCollection list(Map<String, String> params) throws InvalidException, AuthorizationException {
        if (!params.containsKey("type")) {
            throw new InvalidException("a user or admin type must be supplied for a conversation query");
        }
        if (Conversation.isAdminQuery(params) && !params.containsKey("admin_id")) {
            throw new InvalidException("an admin_id must be supplied for an admin conversation query");
        }
        if (Conversation.isUserQuery(params) && !params.containsKey("intercom_user_id") && !params.containsKey("user_id") && !params.containsKey("email")) {
            throw new InvalidException("One of intercom_user_id, user_id or email must be supplied for a user conversation query");
        }
        return DataResource.list(params, "conversations", ConversationCollection.class);
    }

    public static Conversation reply(String id, UserReply reply) {
        URI uri = UriBuilder.newBuilder().path("conversations").path(id).path("reply").build();
        return new HttpClient(uri).post(Conversation.class, new UserReply.UserStringReply(reply));
    }

    public static Conversation reply(String id, AdminReply reply) {
        URI uri = UriBuilder.newBuilder().path("conversations").path(id).path("reply").build();
        return new HttpClient(uri).post(Conversation.class, new AdminReply.AdminStringReply(reply));
    }

    public static UserMessage create(UserMessage message) {
        return DataResource.create(message, "messages", UserMessage.class);
    }

    public static AdminMessage create(AdminMessage message) throws InvalidException {
        if (!message.getTemplate().equals("plain") && !message.getTemplate().equals("personal")) {
            throw new InvalidException("The template must be either personal or plain");
        }
        if (!message.getMessageType().equals("email") && !message.getMessageType().equals("inapp")) {
            throw new InvalidException("The message type must be either email or inapp");
        }
        AdminMessageResponse adminMessageResponse = DataResource.create(message, "messages", AdminMessageResponse.class);
        AdminMessage response = new AdminMessage();
        response.setAdmin(adminMessageResponse.getAdmin());
        response.setBody(adminMessageResponse.getBody());
        response.setCreatedAt(adminMessageResponse.getCreatedAt());
        response.setId(adminMessageResponse.getId());
        response.setMessageType(adminMessageResponse.getMessageType());
        response.setSubject(adminMessageResponse.getSubject());
        response.setTemplate(adminMessageResponse.getTemplate());
        return response;
    }

    private static boolean isUserQuery(Map<String, String> params) {
        return params.containsKey("type") && params.get("type").equals("user");
    }

    private static boolean isAdminQuery(Map<String, String> params) {
        return params.containsKey("type") && params.get("type").equals("admin");
    }

    public String getType() {
        return "conversation";
    }

    public Admin getCurrentAssignee() {
        Admin assignee = null;
        if (this.getAssignee() != null) {
            assignee = this.getAssignee();
        } else if (this.getMostRecentConversationPart() != null && this.getMostRecentConversationPart().getAssignedTo() != null) {
            assignee = this.getMostRecentConversationPart().getAssignedTo();
        }
        return assignee;
    }

    public Optional<ConversationPart> getFirstConversationPart() {
        return Optional.fromNullable((Object)this.getConversationPartCollection().getPageItems().get(0));
    }

    public ConversationPart getMostRecentConversationPart() {
        ConversationPartCollection conversationParts = this.getConversationPartCollection();
        List<ConversationPart> items = conversationParts.getPageItems();
        if (items.isEmpty()) {
            return null;
        }
        return items.get(items.size() - 1);
    }

    public String getId() {
        return this.id;
    }

    public ConversationMessage getConversationMessage() {
        return this.conversationMessage;
    }

    public User getUser() {
        return this.user;
    }

    public Admin getAssignee() {
        return this.assignee;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public ConversationPartCollection getConversationPartCollection() {
        return this.conversationPartCollection;
    }

    public boolean getOpen() {
        return this.open;
    }

    public boolean getRead() {
        return this.read;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation that = (Conversation)o;
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (this.open != that.open) {
            return false;
        }
        if (this.read != that.read) {
            return false;
        }
        if (this.updatedAt != that.updatedAt) {
            return false;
        }
        if (this.assignee != null ? !this.assignee.equals(that.assignee) : that.assignee != null) {
            return false;
        }
        if (this.conversationMessage != null ? !this.conversationMessage.equals(that.conversationMessage) : that.conversationMessage != null) {
            return false;
        }
        if (this.conversationPartCollection != null ? !this.conversationPartCollection.equals(that.conversationPartCollection) : that.conversationPartCollection != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (!"conversation".equals(that.type)) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = "conversation".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.conversationMessage != null ? this.conversationMessage.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.assignee != null ? this.assignee.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (this.conversationPartCollection != null ? this.conversationPartCollection.hashCode() : 0);
        result = 31 * result + (this.open ? 1 : 0);
        result = 31 * result + (this.read ? 1 : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Conversation{type='conversation', id='" + this.id + '\'' + ", conversationMessage=" + this.conversationMessage + ", user=" + this.user + ", assignee=" + this.assignee + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", conversationPartCollection=" + this.conversationPartCollection + ", open=" + this.open + ", read=" + this.read + ", links=" + this.links + "} " + super.toString();
    }
}

