/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.DataResource;
import io.intercom.api.Error;
import io.intercom.api.ErrorCollection;
import io.intercom.api.InvalidException;
import io.intercom.api.TypedData;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Event
extends TypedData {
    private static final ErrorCollection INVALID_NAME = new ErrorCollection(Lists.newArrayList((Object[])new Error[]{new Error("invalid", "an event must supply an event name")}));
    private static final ErrorCollection INVALID_USER = new ErrorCollection(Lists.newArrayList((Object[])new Error[]{new Error("invalid", "an event must supply either an email or a user id")}));
    @JsonProperty(value="type")
    private final String type = "event";
    @JsonProperty(value="event_name")
    private String eventName;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="user_id")
    private String userID;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata = Maps.newHashMap();

    public static void create(Event event) throws InvalidException, AuthorizationException {
        Event.validateCreateEvent(event);
        if (event.getCreatedAt() == 0L) {
            event.setCreatedAt(System.currentTimeMillis() / 1000L);
        }
        DataResource.create(event, "events", Void.class);
    }

    @VisibleForTesting
    static void validateCreateEvent(Event event) {
        if (Strings.isNullOrEmpty((String)event.getEventName())) {
            throw new InvalidException(INVALID_NAME);
        }
        if (Strings.isNullOrEmpty((String)event.getUserID()) && Strings.isNullOrEmpty((String)event.getEmail())) {
            throw new InvalidException(INVALID_USER);
        }
    }

    public String getType() {
        return "event";
    }

    public String getEventName() {
        return this.eventName;
    }

    public Event setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Event setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Event setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getUserID() {
        return this.userID;
    }

    public Event setUserID(String userID) {
        this.userID = userID;
        return this;
    }

    public Event putMetadata(String name, String value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, boolean value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, int value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, double value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, long value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, float value) {
        this.metadata.put(name, Float.valueOf(value));
        return this;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Event setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.createdAt != event.createdAt) {
            return false;
        }
        if (this.email != null ? !this.email.equals(event.email) : event.email != null) {
            return false;
        }
        if (this.eventName != null ? !this.eventName.equals(event.eventName) : event.eventName != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(event.metadata) : event.metadata != null) {
            return false;
        }
        if (!"event".equals(event.type)) {
            return false;
        }
        return !(this.userID != null ? !this.userID.equals(event.userID) : event.userID != null);
    }

    public int hashCode() {
        int result = "event".hashCode();
        result = 31 * result + (this.eventName != null ? this.eventName.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.userID != null ? this.userID.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Event{type='event', eventName='" + this.eventName + '\'' + ", createdAt=" + this.createdAt + ", email='" + this.email + '\'' + ", userID='" + this.userID + '\'' + ", metadata=" + this.metadata + "} " + super.toString();
    }
}

