/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import io.intercom.api.CustomAttribute;
import java.io.IOException;

class CustomAttributeDeserializer
extends StdDeserializer<CustomAttribute> {
    private static final long serialVersionUID = 5069924730975394938L;

    public CustomAttributeDeserializer() {
        super(CustomAttribute.class);
    }

    public CustomAttribute deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        CustomAttribute<Object> cda = null;
        String currentName = jp.getParsingContext().getCurrentName();
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        ValueNode vNode = (ValueNode)mapper.readTree(jp);
        if (vNode.asToken().isScalarValue()) {
            if (vNode.getNodeType() == JsonNodeType.BOOLEAN) {
                cda = new CustomAttribute<Boolean>(currentName, vNode.asBoolean(), Boolean.class);
            } else if (vNode.getNodeType() == JsonNodeType.STRING) {
                cda = new CustomAttribute<String>(currentName, vNode.asText(), String.class);
            } else if (vNode.getNodeType() == JsonNodeType.NUMBER) {
                NumericNode nNode = (NumericNode)vNode;
                cda = currentName.endsWith("_at") ? new CustomAttribute<Long>(currentName, vNode.longValue(), Long.class) : (nNode.isInt() ? new CustomAttribute<Integer>(currentName, vNode.intValue(), Integer.class) : (nNode.isFloat() ? new CustomAttribute<Float>(currentName, Float.valueOf(vNode.floatValue()), Float.class) : (nNode.isDouble() ? new CustomAttribute<Double>(currentName, vNode.doubleValue(), Double.class) : (nNode.isLong() ? new CustomAttribute<Long>(currentName, vNode.longValue(), Long.class) : new CustomAttribute<String>(currentName, vNode.asText(), String.class)))));
            } else {
                cda = new CustomAttribute<String>(currentName, vNode.asText(), String.class);
            }
        }
        return cda;
    }
}

