/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.intercom.api.Admin;
import io.intercom.api.AdminMessage;
import io.intercom.api.AdminMessageResponse;
import io.intercom.api.AdminReply;
import io.intercom.api.AuthorizationException;
import io.intercom.api.ContactMessage;
import io.intercom.api.ConversationCollection;
import io.intercom.api.ConversationMessage;
import io.intercom.api.ConversationPart;
import io.intercom.api.ConversationPartCollection;
import io.intercom.api.ConversationRating;
import io.intercom.api.CustomerFirstReply;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.Reply;
import io.intercom.api.TagCollection;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import io.intercom.api.User;
import io.intercom.api.UserMessage;
import io.intercom.api.UserReply;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Conversation
extends TypedData {
    private static final HashMap<String, String> SENTINEL = Maps.newHashMap();
    private static final List<String> DISPLAY_AS_FORMATS = Lists.newArrayList((Object[])new String[]{"plaintext", "html"});
    static final String MESSAGE_TYPE_ASSIGNMENT = "assignment";
    static final String MESSAGE_TYPE_COMMENT = "comment";
    static final String MESSAGE_TYPE_NOTE = "note";
    static final String MESSAGE_TYPE_CLOSE = "close";
    static final String MESSAGE_TYPE_OPEN = "open";
    static final String MESSAGE_TYPE_SNOOZED = "snoozed";
    static final List<String> MESSAGE_TYPES = Lists.newArrayList((Object[])new String[]{"assignment", "comment", "note", "close", "open", "snoozed"});
    @JsonProperty(value="type")
    private final String type = "conversation";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="conversation_message")
    private ConversationMessage conversationMessage;
    @JsonProperty(value="customer_first_reply")
    private CustomerFirstReply customerFirstReply;
    @JsonProperty(value="conversation_rating")
    private ConversationRating conversationRating;
    @JsonProperty(value="user")
    private User user;
    @JsonProperty(value="assignee")
    private Admin assignee;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="waiting_since")
    private long waitingSince;
    @JsonProperty(value="snoozed_until")
    private long snoozedUntil;
    @JsonProperty(value="conversation_parts")
    private ConversationPartCollection conversationPartCollection;
    @JsonProperty(value="tags")
    private TagCollection tagCollection;
    @JsonProperty(value="open")
    private boolean open;
    @JsonProperty(value="read")
    private boolean read;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="links")
    private Map<String, URI> links;

    public static Conversation find(String id) throws InvalidException, AuthorizationException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("conversations").path(id).build());
        return resource.get(Conversation.class);
    }

    public static Conversation find(String id, Map<String, String> params) throws InvalidException, AuthorizationException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("conversations").path(id).query(params).build());
        return resource.get(Conversation.class);
    }

    public static ConversationCollection list() throws InvalidException, AuthorizationException {
        return DataResource.list(SENTINEL, "conversations", ConversationCollection.class);
    }

    public static ConversationCollection list(Map<String, String> params) throws InvalidException, AuthorizationException {
        Conversation.validateListRequest(params);
        return DataResource.list(params, "conversations", ConversationCollection.class);
    }

    public static Conversation reply(String id, UserReply reply) {
        Conversation.validateUserReplyRequest(reply);
        URI uri = UriBuilder.newBuilder().path("conversations").path(id).path("reply").build();
        return new HttpClient(uri).post(Conversation.class, new UserReply.UserStringReply(reply));
    }

    public static Conversation reply(String id, AdminReply reply) {
        Conversation.validateAdminReplyRequest(reply);
        URI uri = UriBuilder.newBuilder().path("conversations").path(id).path("reply").build();
        return new HttpClient(uri).post(Conversation.class, new AdminReply.AdminStringReply(reply));
    }

    public static Conversation markAsRead(String id) {
        URI uri = UriBuilder.newBuilder().path("conversations").path(id).build();
        return new HttpClient(uri).put(Conversation.class, new ConversationRead());
    }

    public static UserMessage create(UserMessage message) {
        return DataResource.create(message, "messages", UserMessage.class);
    }

    public static ContactMessage create(ContactMessage message) {
        return DataResource.create(message, "messages", ContactMessage.class);
    }

    public static AdminMessage create(AdminMessage message) throws InvalidException {
        if (!message.getTemplate().equals("plain") && !message.getTemplate().equals("personal")) {
            throw new InvalidException("The template must be either personal or plain");
        }
        if (!message.getMessageType().equals("email") && !message.getMessageType().equals("inapp")) {
            throw new InvalidException("The message type must be either email or inapp");
        }
        AdminMessageResponse adminMessageResponse = DataResource.create(message, "messages", AdminMessageResponse.class);
        AdminMessage response = new AdminMessage();
        response.setAdmin(adminMessageResponse.getAdmin());
        response.setBody(adminMessageResponse.getBody());
        response.setCreatedAt(adminMessageResponse.getCreatedAt());
        response.setId(adminMessageResponse.getId());
        response.setMessageType(adminMessageResponse.getMessageType());
        response.setSubject(adminMessageResponse.getSubject());
        response.setTemplate(adminMessageResponse.getTemplate());
        return response;
    }

    public static Conversation runAssignmentRules(String id) {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("conversations").path(id).path("run_assignment_rules").build());
        return resource.post(Conversation.class, null);
    }

    static void validateAdminReplyRequest(AdminReply reply) {
        Conversation.validateMessageType(reply);
        if (reply.getAssigneeID() != null && !MESSAGE_TYPE_ASSIGNMENT.equals(reply.getMessageType())) {
            throw new InvalidException("an assignee id can be set only for a message type of assignment");
        }
        if ((MESSAGE_TYPE_NOTE.equals(reply.getMessageType()) || MESSAGE_TYPE_COMMENT.equals(reply.getMessageType())) && Conversation.isNullOrBlank(reply.getBody())) {
            throw new InvalidException("a comment or note reply must have a body");
        }
    }

    static boolean isNullOrBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    static void validateUserReplyRequest(UserReply reply) {
        if (!MESSAGE_TYPE_COMMENT.equals(reply.getMessageType())) {
            throw new InvalidException("a user reply must have a message type of comment");
        }
    }

    static void validateMessageType(Reply reply) {
        if (!MESSAGE_TYPES.contains(reply.getMessageType())) {
            throw new InvalidException("A reply message type must be one of " + Joiner.on((String)", ").join(MESSAGE_TYPES));
        }
    }

    static void validateListRequest(Map<String, String> params) {
        if (Conversation.isAdminQuery(params) && !params.containsKey("admin_id")) {
            throw new InvalidException("an admin_id must be supplied for an admin conversation query");
        }
        if (params.containsKey("display_as") && !DISPLAY_AS_FORMATS.contains(params.get("display_as"))) {
            throw new InvalidException("A display_as parameter must have one of the values " + Joiner.on((String)", ").join(DISPLAY_AS_FORMATS));
        }
        if (Conversation.isUserQuery(params) && !params.containsKey("intercom_user_id") && !params.containsKey("user_id") && !params.containsKey("email")) {
            throw new InvalidException("One of intercom_user_id, user_id or email must be supplied for a user conversation query");
        }
    }

    private static boolean isUserQuery(Map<String, String> params) {
        return params.containsKey("type") && params.get("type").equals("user");
    }

    private static boolean isAdminQuery(Map<String, String> params) {
        return params.containsKey("type") && params.get("type").equals("admin");
    }

    @Override
    public String getType() {
        return "conversation";
    }

    public Admin getCurrentAssignee() {
        Admin assignee = null;
        if (this.getAssignee() != null) {
            assignee = this.getAssignee();
        } else if (this.getMostRecentConversationPart() != null && this.getMostRecentConversationPart().getAssignedTo() != null) {
            assignee = this.getMostRecentConversationPart().getAssignedTo();
        }
        return assignee;
    }

    public Optional<ConversationPart> getFirstConversationPart() {
        return Optional.fromNullable((Object)this.getConversationPartCollection().getPage().get(0));
    }

    public ConversationPart getMostRecentConversationPart() {
        ConversationPartCollection conversationParts = this.getConversationPartCollection();
        List<ConversationPart> items = conversationParts.getPage();
        if (items.isEmpty()) {
            return null;
        }
        return items.get(items.size() - 1);
    }

    public String getId() {
        return this.id;
    }

    public ConversationMessage getConversationMessage() {
        return this.conversationMessage;
    }

    public CustomerFirstReply getCustomerFirstReply() {
        return this.customerFirstReply;
    }

    public ConversationRating getConversationRating() {
        return this.conversationRating;
    }

    public User getUser() {
        return this.user;
    }

    public Admin getAssignee() {
        return this.assignee;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public long getWaitingSince() {
        return this.waitingSince;
    }

    public long getSnoozedUntil() {
        return this.snoozedUntil;
    }

    public ConversationPartCollection getConversationPartCollection() {
        if (this.conversationPartCollection == null) {
            this.conversationPartCollection = Conversation.find(this.getId()).getConversationPartCollection();
        }
        return this.conversationPartCollection;
    }

    public TagCollection getTagCollection() {
        if (this.tagCollection == null) {
            this.tagCollection = Conversation.find(this.getId()).getTagCollection();
        }
        return this.tagCollection;
    }

    public boolean getOpen() {
        return this.open;
    }

    public boolean getRead() {
        return this.read;
    }

    public String getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation that = (Conversation)o;
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (this.open != that.open) {
            return false;
        }
        if (this.read != that.read) {
            return false;
        }
        if (this.updatedAt != that.updatedAt) {
            return false;
        }
        if (this.waitingSince != that.waitingSince) {
            return false;
        }
        if (this.snoozedUntil != that.snoozedUntil) {
            return false;
        }
        if (this.assignee != null ? !this.assignee.equals(that.assignee) : that.assignee != null) {
            return false;
        }
        if (this.conversationMessage != null ? !this.conversationMessage.equals(that.conversationMessage) : that.conversationMessage != null) {
            return false;
        }
        if (this.conversationRating != null ? !this.conversationRating.equals(that.conversationRating) : that.conversationRating != null) {
            return false;
        }
        if (this.conversationPartCollection != null ? !this.conversationPartCollection.equals(that.conversationPartCollection) : that.conversationPartCollection != null) {
            return false;
        }
        if (this.tagCollection != null ? !this.tagCollection.equals(that.tagCollection) : that.tagCollection != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (!this.state.equals(that.state)) {
            return false;
        }
        if (!"conversation".equals(that.type)) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = "conversation".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.conversationMessage != null ? this.conversationMessage.hashCode() : 0);
        result = 31 * result + (this.conversationRating != null ? this.conversationRating.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.assignee != null ? this.assignee.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (int)(this.waitingSince ^ this.waitingSince >>> 32);
        result = 31 * result + (int)(this.snoozedUntil ^ this.snoozedUntil >>> 32);
        result = 31 * result + (this.conversationPartCollection != null ? this.conversationPartCollection.hashCode() : 0);
        result = 31 * result + (this.tagCollection != null ? this.tagCollection.hashCode() : 0);
        result = 31 * result + (this.open ? 1 : 0);
        result = 31 * result + (this.read ? 1 : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Conversation{type='conversation', id='" + this.id + '\'' + ", conversationMessage=" + this.conversationMessage + ", user=" + this.user + ", assignee=" + this.assignee + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", waitingSince=" + this.waitingSince + ", snoozedUntil=" + this.snoozedUntil + ", conversationPartCollection=" + this.conversationPartCollection + ", tagCollection=" + this.tagCollection + ", open=" + this.open + ", state=" + this.state + ", read=" + this.read + ", links=" + this.links + ", conversationRating=" + this.conversationRating + "} " + super.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ConversationRead
    extends TypedData {
        @JsonProperty(value="read")
        private boolean read = true;
    }
}

