/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.news.feeds.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FindNewsFeedRequest.Builder.class)
public final class FindNewsFeedRequest {
    private final String newsfeedId;

    private final Map<String, Object> additionalProperties;

    private FindNewsFeedRequest(String newsfeedId, Map<String, Object> additionalProperties) {
        this.newsfeedId = newsfeedId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the news feed item which is given by Intercom.
     */
    @JsonProperty("newsfeed_id")
    public String getNewsfeedId() {
        return newsfeedId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FindNewsFeedRequest && equalTo((FindNewsFeedRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindNewsFeedRequest other) {
        return newsfeedId.equals(other.newsfeedId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.newsfeedId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NewsfeedIdStage builder() {
        return new Builder();
    }

    public interface NewsfeedIdStage {
        /**
         * The unique identifier for the news feed item which is given by Intercom.
         */
        _FinalStage newsfeedId(@NotNull String newsfeedId);

        Builder from(FindNewsFeedRequest other);
    }

    public interface _FinalStage {
        FindNewsFeedRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NewsfeedIdStage, _FinalStage {
        private String newsfeedId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FindNewsFeedRequest other) {
            newsfeedId(other.getNewsfeedId());
            return this;
        }

        /**
         * The unique identifier for the news feed item which is given by Intercom.<p>The unique identifier for the news feed item which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("newsfeed_id")
        public _FinalStage newsfeedId(@NotNull String newsfeedId) {
            this.newsfeedId = Objects.requireNonNull(newsfeedId, "newsfeedId must not be null");
            return this;
        }

        @java.lang.Override
        public FindNewsFeedRequest build() {
            return new FindNewsFeedRequest(newsfeedId, additionalProperties);
        }
    }
}
