/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.notes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FindNoteRequest.Builder.class)
public final class FindNoteRequest {
    private final String noteId;

    private final Map<String, Object> additionalProperties;

    private FindNoteRequest(String noteId, Map<String, Object> additionalProperties) {
        this.noteId = noteId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of a given note
     */
    @JsonProperty("note_id")
    public String getNoteId() {
        return noteId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FindNoteRequest && equalTo((FindNoteRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindNoteRequest other) {
        return noteId.equals(other.noteId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.noteId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NoteIdStage builder() {
        return new Builder();
    }

    public interface NoteIdStage {
        /**
         * The unique identifier of a given note
         */
        _FinalStage noteId(@NotNull String noteId);

        Builder from(FindNoteRequest other);
    }

    public interface _FinalStage {
        FindNoteRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NoteIdStage, _FinalStage {
        private String noteId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FindNoteRequest other) {
            noteId(other.getNoteId());
            return this;
        }

        /**
         * The unique identifier of a given note<p>The unique identifier of a given note</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("note_id")
        public _FinalStage noteId(@NotNull String noteId) {
            this.noteId = Objects.requireNonNull(noteId, "noteId must not be null");
            return this;
        }

        @java.lang.Override
        public FindNoteRequest build() {
            return new FindNoteRequest(noteId, additionalProperties);
        }
    }
}
