/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateContactRequest.Builder.class)
public final class UpdateContactRequest {
    private final String id;

    private final Optional<String> role;

    private final Optional<String> externalId;

    private final Optional<String> email;

    private final Optional<String> phone;

    private final Optional<String> name;

    private final Optional<String> avatar;

    private final Optional<Integer> signedUpAt;

    private final Optional<Integer> lastSeenAt;

    private final Optional<Integer> ownerId;

    private final Optional<Boolean> unsubscribedFromEmails;

    private final Optional<Map<String, Object>> customAttributes;

    private final Map<String, Object> additionalProperties;

    private UpdateContactRequest(
            String id,
            Optional<String> role,
            Optional<String> externalId,
            Optional<String> email,
            Optional<String> phone,
            Optional<String> name,
            Optional<String> avatar,
            Optional<Integer> signedUpAt,
            Optional<Integer> lastSeenAt,
            Optional<Integer> ownerId,
            Optional<Boolean> unsubscribedFromEmails,
            Optional<Map<String, Object>> customAttributes,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.role = role;
        this.externalId = externalId;
        this.email = email;
        this.phone = phone;
        this.name = name;
        this.avatar = avatar;
        this.signedUpAt = signedUpAt;
        this.lastSeenAt = lastSeenAt;
        this.ownerId = ownerId;
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return id
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The role of the contact.
     */
    @JsonProperty("role")
    public Optional<String> getRole() {
        return role;
    }

    /**
     * @return A unique identifier for the contact which is given to Intercom
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return The contacts email
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return The contacts phone
     */
    @JsonProperty("phone")
    public Optional<String> getPhone() {
        return phone;
    }

    /**
     * @return The contacts name
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return An image URL containing the avatar of a contact
     */
    @JsonProperty("avatar")
    public Optional<String> getAvatar() {
        return avatar;
    }

    /**
     * @return The time specified for when a contact signed up
     */
    @JsonProperty("signed_up_at")
    public Optional<Integer> getSignedUpAt() {
        return signedUpAt;
    }

    /**
     * @return The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)
     */
    @JsonProperty("last_seen_at")
    public Optional<Integer> getLastSeenAt() {
        return lastSeenAt;
    }

    /**
     * @return The id of an admin that has been assigned account ownership of the contact
     */
    @JsonProperty("owner_id")
    public Optional<Integer> getOwnerId() {
        return ownerId;
    }

    /**
     * @return Whether the contact is unsubscribed from emails
     */
    @JsonProperty("unsubscribed_from_emails")
    public Optional<Boolean> getUnsubscribedFromEmails() {
        return unsubscribedFromEmails;
    }

    /**
     * @return The custom attributes which are set for the contact
     */
    @JsonProperty("custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return customAttributes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateContactRequest && equalTo((UpdateContactRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateContactRequest other) {
        return id.equals(other.id)
                && role.equals(other.role)
                && externalId.equals(other.externalId)
                && email.equals(other.email)
                && phone.equals(other.phone)
                && name.equals(other.name)
                && avatar.equals(other.avatar)
                && signedUpAt.equals(other.signedUpAt)
                && lastSeenAt.equals(other.lastSeenAt)
                && ownerId.equals(other.ownerId)
                && unsubscribedFromEmails.equals(other.unsubscribedFromEmails)
                && customAttributes.equals(other.customAttributes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.role,
                this.externalId,
                this.email,
                this.phone,
                this.name,
                this.avatar,
                this.signedUpAt,
                this.lastSeenAt,
                this.ownerId,
                this.unsubscribedFromEmails,
                this.customAttributes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * id
         */
        _FinalStage id(@NotNull String id);

        Builder from(UpdateContactRequest other);
    }

    public interface _FinalStage {
        UpdateContactRequest build();

        /**
         * <p>The role of the contact.</p>
         */
        _FinalStage role(Optional<String> role);

        _FinalStage role(String role);

        /**
         * <p>A unique identifier for the contact which is given to Intercom</p>
         */
        _FinalStage externalId(Optional<String> externalId);

        _FinalStage externalId(String externalId);

        /**
         * <p>The contacts email</p>
         */
        _FinalStage email(Optional<String> email);

        _FinalStage email(String email);

        /**
         * <p>The contacts phone</p>
         */
        _FinalStage phone(Optional<String> phone);

        _FinalStage phone(String phone);

        /**
         * <p>The contacts name</p>
         */
        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        /**
         * <p>An image URL containing the avatar of a contact</p>
         */
        _FinalStage avatar(Optional<String> avatar);

        _FinalStage avatar(String avatar);

        /**
         * <p>The time specified for when a contact signed up</p>
         */
        _FinalStage signedUpAt(Optional<Integer> signedUpAt);

        _FinalStage signedUpAt(Integer signedUpAt);

        /**
         * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
         */
        _FinalStage lastSeenAt(Optional<Integer> lastSeenAt);

        _FinalStage lastSeenAt(Integer lastSeenAt);

        /**
         * <p>The id of an admin that has been assigned account ownership of the contact</p>
         */
        _FinalStage ownerId(Optional<Integer> ownerId);

        _FinalStage ownerId(Integer ownerId);

        /**
         * <p>Whether the contact is unsubscribed from emails</p>
         */
        _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails);

        _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails);

        /**
         * <p>The custom attributes which are set for the contact</p>
         */
        _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes);

        _FinalStage customAttributes(Map<String, Object> customAttributes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private String id;

        private Optional<Map<String, Object>> customAttributes = Optional.empty();

        private Optional<Boolean> unsubscribedFromEmails = Optional.empty();

        private Optional<Integer> ownerId = Optional.empty();

        private Optional<Integer> lastSeenAt = Optional.empty();

        private Optional<Integer> signedUpAt = Optional.empty();

        private Optional<String> avatar = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> phone = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> externalId = Optional.empty();

        private Optional<String> role = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateContactRequest other) {
            id(other.getId());
            role(other.getRole());
            externalId(other.getExternalId());
            email(other.getEmail());
            phone(other.getPhone());
            name(other.getName());
            avatar(other.getAvatar());
            signedUpAt(other.getSignedUpAt());
            lastSeenAt(other.getLastSeenAt());
            ownerId(other.getOwnerId());
            unsubscribedFromEmails(other.getUnsubscribedFromEmails());
            customAttributes(other.getCustomAttributes());
            return this;
        }

        /**
         * id<p>id</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>The custom attributes which are set for the contact</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        /**
         * <p>The custom attributes which are set for the contact</p>
         */
        @java.lang.Override
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * <p>Whether the contact is unsubscribed from emails</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
            this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
            return this;
        }

        /**
         * <p>Whether the contact is unsubscribed from emails</p>
         */
        @java.lang.Override
        @JsonSetter(value = "unsubscribed_from_emails", nulls = Nulls.SKIP)
        public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            return this;
        }

        /**
         * <p>The id of an admin that has been assigned account ownership of the contact</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage ownerId(Integer ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        /**
         * <p>The id of an admin that has been assigned account ownership of the contact</p>
         */
        @java.lang.Override
        @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
        public _FinalStage ownerId(Optional<Integer> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage lastSeenAt(Integer lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        /**
         * <p>The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "last_seen_at", nulls = Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        /**
         * <p>The time specified for when a contact signed up</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage signedUpAt(Integer signedUpAt) {
            this.signedUpAt = Optional.ofNullable(signedUpAt);
            return this;
        }

        /**
         * <p>The time specified for when a contact signed up</p>
         */
        @java.lang.Override
        @JsonSetter(value = "signed_up_at", nulls = Nulls.SKIP)
        public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
            this.signedUpAt = signedUpAt;
            return this;
        }

        /**
         * <p>An image URL containing the avatar of a contact</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage avatar(String avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        /**
         * <p>An image URL containing the avatar of a contact</p>
         */
        @java.lang.Override
        @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
        public _FinalStage avatar(Optional<String> avatar) {
            this.avatar = avatar;
            return this;
        }

        /**
         * <p>The contacts name</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The contacts name</p>
         */
        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        /**
         * <p>The contacts phone</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        /**
         * <p>The contacts phone</p>
         */
        @java.lang.Override
        @JsonSetter(value = "phone", nulls = Nulls.SKIP)
        public _FinalStage phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        /**
         * <p>The contacts email</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The contacts email</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        /**
         * <p>A unique identifier for the contact which is given to Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>A unique identifier for the contact which is given to Intercom</p>
         */
        @java.lang.Override
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * <p>The role of the contact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage role(String role) {
            this.role = Optional.ofNullable(role);
            return this;
        }

        /**
         * <p>The role of the contact.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "role", nulls = Nulls.SKIP)
        public _FinalStage role(Optional<String> role) {
            this.role = role;
            return this;
        }

        @java.lang.Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(
                    id,
                    role,
                    externalId,
                    email,
                    phone,
                    name,
                    avatar,
                    signedUpAt,
                    lastSeenAt,
                    ownerId,
                    unsubscribedFromEmails,
                    customAttributes,
                    additionalProperties);
        }
    }
}
