/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.subscriptiontypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.subscriptiontypes.requests.AttachSubscriptionTypeToContactRequest;
import com.intercom.api.resources.unstable.subscriptiontypes.requests.DetachSubscriptionTypeToContactRequest;
import com.intercom.api.resources.unstable.subscriptiontypes.types.SubscriptionType;
import com.intercom.api.resources.unstable.types.SubscriptionTypeList;
import java.util.concurrent.CompletableFuture;

public class AsyncSubscriptionTypesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawSubscriptionTypesClient rawClient;

    public AsyncSubscriptionTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSubscriptionTypesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawSubscriptionTypesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:
     * <p>1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.</p>
     * <p>2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.</p>
     * <p>This will return a subscription type model for the subscription type that was added to the contact.</p>
     */
    public CompletableFuture<SubscriptionType> attachSubscriptionTypeToContact(
            AttachSubscriptionTypeToContactRequest request) {
        return this.rawClient.attachSubscriptionTypeToContact(request).thenApply(response -> response.body());
    }

    /**
     * You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:
     * <p>1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.</p>
     * <p>2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.</p>
     * <p>This will return a subscription type model for the subscription type that was added to the contact.</p>
     */
    public CompletableFuture<SubscriptionType> attachSubscriptionTypeToContact(
            AttachSubscriptionTypeToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .attachSubscriptionTypeToContact(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.
     */
    public CompletableFuture<SubscriptionType> detachSubscriptionTypeToContact(
            DetachSubscriptionTypeToContactRequest request) {
        return this.rawClient.detachSubscriptionTypeToContact(request).thenApply(response -> response.body());
    }

    /**
     * You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.
     */
    public CompletableFuture<SubscriptionType> detachSubscriptionTypeToContact(
            DetachSubscriptionTypeToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .detachSubscriptionTypeToContact(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * You can list all subscription types. A list of subscription type objects will be returned.
     */
    public CompletableFuture<SubscriptionTypeList> listSubscriptionTypes() {
        return this.rawClient.listSubscriptionTypes().thenApply(response -> response.body());
    }

    /**
     * You can list all subscription types. A list of subscription type objects will be returned.
     */
    public CompletableFuture<SubscriptionTypeList> listSubscriptionTypes(RequestOptions requestOptions) {
        return this.rawClient.listSubscriptionTypes(requestOptions).thenApply(response -> response.body());
    }
}
