/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.tickets.types.Ticket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketList.Builder.class)
public final class TicketList {
    private final Optional<String> type;

    private final Optional<List<Optional<Ticket>>> tickets;

    private final Optional<Integer> totalCount;

    private final Optional<CursorPages> pages;

    private final Map<String, Object> additionalProperties;

    private TicketList(
            Optional<String> type,
            Optional<List<Optional<Ticket>>> tickets,
            Optional<Integer> totalCount,
            Optional<CursorPages> pages,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.tickets = tickets;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always ticket.list
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The list of ticket objects
     */
    @JsonProperty("tickets")
    public Optional<List<Optional<Ticket>>> getTickets() {
        return tickets;
    }

    /**
     * @return A count of the total number of objects.
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketList && equalTo((TicketList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketList other) {
        return type.equals(other.type)
                && tickets.equals(other.tickets)
                && totalCount.equals(other.totalCount)
                && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.tickets, this.totalCount, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Optional<Ticket>>> tickets = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<CursorPages> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketList other) {
            type(other.getType());
            tickets(other.getTickets());
            totalCount(other.getTotalCount());
            pages(other.getPages());
            return this;
        }

        /**
         * <p>Always ticket.list</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The list of ticket objects</p>
         */
        @JsonSetter(value = "tickets", nulls = Nulls.SKIP)
        public Builder tickets(Optional<List<Optional<Ticket>>> tickets) {
            this.tickets = tickets;
            return this;
        }

        public Builder tickets(List<Optional<Ticket>> tickets) {
            this.tickets = Optional.ofNullable(tickets);
            return this;
        }

        /**
         * <p>A count of the total number of objects.</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public TicketList build() {
            return new TicketList(type, tickets, totalCount, pages, additionalProperties);
        }
    }
}
