/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.visitors.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = MergeVisitorToContactRequest.Builder.class)
public final class MergeVisitorToContactRequest {
    private final String type;

    private final User user;

    private final Visitor visitor;

    private final Map<String, Object> additionalProperties;

    private MergeVisitorToContactRequest(
            String type, User user, Visitor visitor, Map<String, Object> additionalProperties) {
        this.type = type;
        this.user = user;
        this.visitor = visitor;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Represents the role of the Contact model. Accepts <code>lead</code> or <code>user</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The unique identifiers retained after converting or merging.
     */
    @JsonProperty("user")
    public User getUser() {
        return user;
    }

    /**
     * @return The unique identifiers to convert a single Visitor.
     */
    @JsonProperty("visitor")
    public Visitor getVisitor() {
        return visitor;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof MergeVisitorToContactRequest && equalTo((MergeVisitorToContactRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MergeVisitorToContactRequest other) {
        return type.equals(other.type) && user.equals(other.user) && visitor.equals(other.visitor);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.user, this.visitor);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * Represents the role of the Contact model. Accepts `lead` or `user`.
         */
        UserStage type(@NotNull String type);

        Builder from(MergeVisitorToContactRequest other);
    }

    public interface UserStage {
        /**
         * The unique identifiers retained after converting or merging.
         */
        VisitorStage user(@NotNull User user);
    }

    public interface VisitorStage {
        /**
         * The unique identifiers to convert a single Visitor.
         */
        _FinalStage visitor(@NotNull Visitor visitor);
    }

    public interface _FinalStage {
        MergeVisitorToContactRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, UserStage, VisitorStage, _FinalStage {
        private String type;

        private User user;

        private Visitor visitor;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(MergeVisitorToContactRequest other) {
            type(other.getType());
            user(other.getUser());
            visitor(other.getVisitor());
            return this;
        }

        /**
         * Represents the role of the Contact model. Accepts `lead` or `user`.<p>Represents the role of the Contact model. Accepts <code>lead</code> or <code>user</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public UserStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * The unique identifiers retained after converting or merging.<p>The unique identifiers retained after converting or merging.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user")
        public VisitorStage user(@NotNull User user) {
            this.user = Objects.requireNonNull(user, "user must not be null");
            return this;
        }

        /**
         * The unique identifiers to convert a single Visitor.<p>The unique identifiers to convert a single Visitor.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("visitor")
        public _FinalStage visitor(@NotNull Visitor visitor) {
            this.visitor = Objects.requireNonNull(visitor, "visitor must not be null");
            return this;
        }

        @java.lang.Override
        public MergeVisitorToContactRequest build() {
            return new MergeVisitorToContactRequest(type, user, visitor, additionalProperties);
        }
    }

    @JsonDeserialize(using = User.Deserializer.class)
    public static final class User {
        private final Object value;

        private final int type;

        private User(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((UserWithId) this.value);
            } else if (this.type == 1) {
                return visitor.visit((UserWithUserId) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof User && equalTo((User) other);
        }

        private boolean equalTo(User other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static User of(UserWithId value) {
            return new User(value, 0);
        }

        public static User of(UserWithUserId value) {
            return new User(value, 1);
        }

        public interface Visitor<T> {
            T visit(UserWithId value);

            T visit(UserWithUserId value);
        }

        static final class Deserializer extends StdDeserializer<User> {
            Deserializer() {
                super(User.class);
            }

            @java.lang.Override
            public User deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, UserWithId.class));
                } catch (IllegalArgumentException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, UserWithUserId.class));
                } catch (IllegalArgumentException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = UserWithId.Builder.class)
        public static final class UserWithId {
            private final String id;

            private final Optional<String> email;

            private final Map<String, Object> additionalProperties;

            private UserWithId(String id, Optional<String> email, Map<String, Object> additionalProperties) {
                this.id = id;
                this.email = email;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The unique identifier for the contact which is given by Intercom.
             */
            @JsonProperty("id")
            public String getId() {
                return id;
            }

            /**
             * @return The contact's email, retained by default if one is present.
             */
            @JsonProperty("email")
            public Optional<String> getEmail() {
                return email;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof UserWithId && equalTo((UserWithId) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(UserWithId other) {
                return id.equals(other.id) && email.equals(other.email);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.id, this.email);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            public interface IdStage {
                /**
                 * The unique identifier for the contact which is given by Intercom.
                 */
                _FinalStage id(@NotNull String id);

                Builder from(UserWithId other);
            }

            public interface _FinalStage {
                UserWithId build();

                /**
                 * <p>The contact's email, retained by default if one is present.</p>
                 */
                _FinalStage email(Optional<String> email);

                _FinalStage email(String email);
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements IdStage, _FinalStage {
                private String id;

                private Optional<String> email = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(UserWithId other) {
                    id(other.getId());
                    email(other.getEmail());
                    return this;
                }

                /**
                 * The unique identifier for the contact which is given by Intercom.<p>The unique identifier for the contact which is given by Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                /**
                 * <p>The contact's email, retained by default if one is present.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                public _FinalStage email(String email) {
                    this.email = Optional.ofNullable(email);
                    return this;
                }

                /**
                 * <p>The contact's email, retained by default if one is present.</p>
                 */
                @java.lang.Override
                @JsonSetter(value = "email", nulls = Nulls.SKIP)
                public _FinalStage email(Optional<String> email) {
                    this.email = email;
                    return this;
                }

                @java.lang.Override
                public UserWithId build() {
                    return new UserWithId(id, email, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = UserWithUserId.Builder.class)
        public static final class UserWithUserId {
            private final String userId;

            private final Optional<String> email;

            private final Map<String, Object> additionalProperties;

            private UserWithUserId(String userId, Optional<String> email, Map<String, Object> additionalProperties) {
                this.userId = userId;
                this.email = email;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return A unique identifier for the contact which is given to Intercom.
             */
            @JsonProperty("user_id")
            public String getUserId() {
                return userId;
            }

            /**
             * @return The contact's email, retained by default if one is present.
             */
            @JsonProperty("email")
            public Optional<String> getEmail() {
                return email;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof UserWithUserId && equalTo((UserWithUserId) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(UserWithUserId other) {
                return userId.equals(other.userId) && email.equals(other.email);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.userId, this.email);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static UserIdStage builder() {
                return new Builder();
            }

            public interface UserIdStage {
                /**
                 * A unique identifier for the contact which is given to Intercom.
                 */
                _FinalStage userId(@NotNull String userId);

                Builder from(UserWithUserId other);
            }

            public interface _FinalStage {
                UserWithUserId build();

                /**
                 * <p>The contact's email, retained by default if one is present.</p>
                 */
                _FinalStage email(Optional<String> email);

                _FinalStage email(String email);
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements UserIdStage, _FinalStage {
                private String userId;

                private Optional<String> email = Optional.empty();

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(UserWithUserId other) {
                    userId(other.getUserId());
                    email(other.getEmail());
                    return this;
                }

                /**
                 * A unique identifier for the contact which is given to Intercom.<p>A unique identifier for the contact which is given to Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("user_id")
                public _FinalStage userId(@NotNull String userId) {
                    this.userId = Objects.requireNonNull(userId, "userId must not be null");
                    return this;
                }

                /**
                 * <p>The contact's email, retained by default if one is present.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                public _FinalStage email(String email) {
                    this.email = Optional.ofNullable(email);
                    return this;
                }

                /**
                 * <p>The contact's email, retained by default if one is present.</p>
                 */
                @java.lang.Override
                @JsonSetter(value = "email", nulls = Nulls.SKIP)
                public _FinalStage email(Optional<String> email) {
                    this.email = email;
                    return this;
                }

                @java.lang.Override
                public UserWithUserId build() {
                    return new UserWithUserId(userId, email, additionalProperties);
                }
            }
        }
    }

    @JsonDeserialize(using = Visitor.Deserializer.class)
    public static final class Visitor {
        private final Object value;

        private final int type;

        private Visitor(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor_<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((VisitorWithId) this.value);
            } else if (this.type == 1) {
                return visitor.visit((VisitorWithUserId) this.value);
            } else if (this.type == 2) {
                return visitor.visit((VisitorWithEmail) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Visitor && equalTo((Visitor) other);
        }

        private boolean equalTo(Visitor other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static Visitor of(VisitorWithId value) {
            return new Visitor(value, 0);
        }

        public static Visitor of(VisitorWithUserId value) {
            return new Visitor(value, 1);
        }

        public static Visitor of(VisitorWithEmail value) {
            return new Visitor(value, 2);
        }

        public interface Visitor_<T> {
            T visit(VisitorWithId value);

            T visit(VisitorWithUserId value);

            T visit(VisitorWithEmail value);
        }

        static final class Deserializer extends StdDeserializer<Visitor> {
            Deserializer() {
                super(Visitor.class);
            }

            @java.lang.Override
            public Visitor deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, VisitorWithId.class));
                } catch (IllegalArgumentException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, VisitorWithUserId.class));
                } catch (IllegalArgumentException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, VisitorWithEmail.class));
                } catch (IllegalArgumentException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = VisitorWithEmail.Builder.class)
        public static final class VisitorWithEmail {
            private final String email;

            private final Map<String, Object> additionalProperties;

            private VisitorWithEmail(String email, Map<String, Object> additionalProperties) {
                this.email = email;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The visitor's email.
             */
            @JsonProperty("email")
            public String getEmail() {
                return email;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof VisitorWithEmail && equalTo((VisitorWithEmail) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(VisitorWithEmail other) {
                return email.equals(other.email);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.email);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static EmailStage builder() {
                return new Builder();
            }

            public interface EmailStage {
                /**
                 * The visitor's email.
                 */
                _FinalStage email(@NotNull String email);

                Builder from(VisitorWithEmail other);
            }

            public interface _FinalStage {
                VisitorWithEmail build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements EmailStage, _FinalStage {
                private String email;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(VisitorWithEmail other) {
                    email(other.getEmail());
                    return this;
                }

                /**
                 * The visitor's email.<p>The visitor's email.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("email")
                public _FinalStage email(@NotNull String email) {
                    this.email = Objects.requireNonNull(email, "email must not be null");
                    return this;
                }

                @java.lang.Override
                public VisitorWithEmail build() {
                    return new VisitorWithEmail(email, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = VisitorWithId.Builder.class)
        public static final class VisitorWithId {
            private final String id;

            private final Map<String, Object> additionalProperties;

            private VisitorWithId(String id, Map<String, Object> additionalProperties) {
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The unique identifier for the contact which is given by Intercom.
             */
            @JsonProperty("id")
            public String getId() {
                return id;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof VisitorWithId && equalTo((VisitorWithId) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(VisitorWithId other) {
                return id.equals(other.id);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.id);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            public interface IdStage {
                /**
                 * The unique identifier for the contact which is given by Intercom.
                 */
                _FinalStage id(@NotNull String id);

                Builder from(VisitorWithId other);
            }

            public interface _FinalStage {
                VisitorWithId build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements IdStage, _FinalStage {
                private String id;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(VisitorWithId other) {
                    id(other.getId());
                    return this;
                }

                /**
                 * The unique identifier for the contact which is given by Intercom.<p>The unique identifier for the contact which is given by Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @java.lang.Override
                public VisitorWithId build() {
                    return new VisitorWithId(id, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = VisitorWithUserId.Builder.class)
        public static final class VisitorWithUserId {
            private final String userId;

            private final Map<String, Object> additionalProperties;

            private VisitorWithUserId(String userId, Map<String, Object> additionalProperties) {
                this.userId = userId;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return A unique identifier for the contact which is given to Intercom.
             */
            @JsonProperty("user_id")
            public String getUserId() {
                return userId;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof VisitorWithUserId && equalTo((VisitorWithUserId) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(VisitorWithUserId other) {
                return userId.equals(other.userId);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.userId);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static UserIdStage builder() {
                return new Builder();
            }

            public interface UserIdStage {
                /**
                 * A unique identifier for the contact which is given to Intercom.
                 */
                _FinalStage userId(@NotNull String userId);

                Builder from(VisitorWithUserId other);
            }

            public interface _FinalStage {
                VisitorWithUserId build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements UserIdStage, _FinalStage {
                private String userId;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(VisitorWithUserId other) {
                    userId(other.getUserId());
                    return this;
                }

                /**
                 * A unique identifier for the contact which is given to Intercom.<p>A unique identifier for the contact which is given to Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("user_id")
                public _FinalStage userId(@NotNull String userId) {
                    this.userId = Objects.requireNonNull(userId, "userId must not be null");
                    return this;
                }

                @java.lang.Override
                public VisitorWithUserId build() {
                    return new VisitorWithUserId(userId, additionalProperties);
                }
            }
        }
    }
}
