/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationParts.Builder.class)
public final class ConversationParts {
    private final List<ConversationPart> conversationParts;

    private final int totalCount;

    private final Map<String, Object> additionalProperties;

    private ConversationParts(
            List<ConversationPart> conversationParts, int totalCount, Map<String, Object> additionalProperties) {
        this.conversationParts = conversationParts;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return
     */
    @JsonProperty("type")
    public String getType() {
        return "conversation_part.list";
    }

    /**
     * @return A list of Conversation Part objects for each part message in the conversation. This is only returned when Retrieving a Conversation, and ignored when Listing all Conversations. There is a limit of 500 parts.
     */
    @JsonProperty("conversation_parts")
    public List<ConversationPart> getConversationParts() {
        return conversationParts;
    }

    /**
     * @return
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationParts && equalTo((ConversationParts) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationParts other) {
        return conversationParts.equals(other.conversationParts) && totalCount == other.totalCount;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversationParts, this.totalCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        _FinalStage totalCount(int totalCount);

        Builder from(ConversationParts other);
    }

    public interface _FinalStage {
        ConversationParts build();

        /**
         * <p>A list of Conversation Part objects for each part message in the conversation. This is only returned when Retrieving a Conversation, and ignored when Listing all Conversations. There is a limit of 500 parts.</p>
         */
        _FinalStage conversationParts(List<ConversationPart> conversationParts);

        _FinalStage addConversationParts(ConversationPart conversationParts);

        _FinalStage addAllConversationParts(List<ConversationPart> conversationParts);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private List<ConversationPart> conversationParts = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationParts other) {
            conversationParts(other.getConversationParts());
            totalCount(other.getTotalCount());
            return this;
        }

        /**
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * <p>A list of Conversation Part objects for each part message in the conversation. This is only returned when Retrieving a Conversation, and ignored when Listing all Conversations. There is a limit of 500 parts.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllConversationParts(List<ConversationPart> conversationParts) {
            this.conversationParts.addAll(conversationParts);
            return this;
        }

        /**
         * <p>A list of Conversation Part objects for each part message in the conversation. This is only returned when Retrieving a Conversation, and ignored when Listing all Conversations. There is a limit of 500 parts.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addConversationParts(ConversationPart conversationParts) {
            this.conversationParts.add(conversationParts);
            return this;
        }

        /**
         * <p>A list of Conversation Part objects for each part message in the conversation. This is only returned when Retrieving a Conversation, and ignored when Listing all Conversations. There is a limit of 500 parts.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "conversation_parts", nulls = Nulls.SKIP)
        public _FinalStage conversationParts(List<ConversationPart> conversationParts) {
            this.conversationParts.clear();
            this.conversationParts.addAll(conversationParts);
            return this;
        }

        @java.lang.Override
        public ConversationParts build() {
            return new ConversationParts(conversationParts, totalCount, additionalProperties);
        }
    }
}
