/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DropdownComponent.Builder.class)
public final class DropdownComponent {
    private final String id;

    private final List<DropdownOption> options;

    private final Optional<String> label;

    private final Optional<String> value;

    private final Optional<SaveState> saveState;

    private final Optional<Boolean> disabled;

    private final Map<String, Object> additionalProperties;

    private DropdownComponent(
            String id,
            List<DropdownOption> options,
            Optional<String> label,
            Optional<String> value,
            Optional<SaveState> saveState,
            Optional<Boolean> disabled,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.options = options;
        this.label = label;
        this.value = value;
        this.saveState = saveState;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return A unique identifier for the component.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The list of options. Can provide 2 to 10.
     */
    @JsonProperty("options")
    public List<DropdownOption> getOptions() {
        return options;
    }

    /**
     * @return The text shown above the dropdown.
     */
    @JsonProperty("label")
    public Optional<String> getLabel() {
        return label;
    }

    /**
     * @return The option that is selected by default.
     */
    @JsonProperty("value")
    public Optional<String> getValue() {
        return value;
    }

    /**
     * @return Styles all options and prevents the action. Default is <code>unsaved</code>. Will be overridden if <code>save_state</code> is <code>saved</code>.
     */
    @JsonProperty("save_state")
    public Optional<SaveState> getSaveState() {
        return saveState;
    }

    /**
     * @return Styles all options and prevents the action. Default is false. Will be overridden if save_state is saved.
     */
    @JsonProperty("disabled")
    public Optional<Boolean> getDisabled() {
        return disabled;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DropdownComponent && equalTo((DropdownComponent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DropdownComponent other) {
        return id.equals(other.id)
                && options.equals(other.options)
                && label.equals(other.label)
                && value.equals(other.value)
                && saveState.equals(other.saveState)
                && disabled.equals(other.disabled);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.options, this.label, this.value, this.saveState, this.disabled);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * A unique identifier for the component.
         */
        _FinalStage id(@NotNull String id);

        Builder from(DropdownComponent other);
    }

    public interface _FinalStage {
        DropdownComponent build();

        /**
         * <p>The list of options. Can provide 2 to 10.</p>
         */
        _FinalStage options(List<DropdownOption> options);

        _FinalStage addOptions(DropdownOption options);

        _FinalStage addAllOptions(List<DropdownOption> options);

        /**
         * <p>The text shown above the dropdown.</p>
         */
        _FinalStage label(Optional<String> label);

        _FinalStage label(String label);

        /**
         * <p>The option that is selected by default.</p>
         */
        _FinalStage value(Optional<String> value);

        _FinalStage value(String value);

        /**
         * <p>Styles all options and prevents the action. Default is <code>unsaved</code>. Will be overridden if <code>save_state</code> is <code>saved</code>.</p>
         */
        _FinalStage saveState(Optional<SaveState> saveState);

        _FinalStage saveState(SaveState saveState);

        /**
         * <p>Styles all options and prevents the action. Default is false. Will be overridden if save_state is saved.</p>
         */
        _FinalStage disabled(Optional<Boolean> disabled);

        _FinalStage disabled(Boolean disabled);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private String id;

        private Optional<Boolean> disabled = Optional.empty();

        private Optional<SaveState> saveState = Optional.empty();

        private Optional<String> value = Optional.empty();

        private Optional<String> label = Optional.empty();

        private List<DropdownOption> options = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DropdownComponent other) {
            id(other.getId());
            options(other.getOptions());
            label(other.getLabel());
            value(other.getValue());
            saveState(other.getSaveState());
            disabled(other.getDisabled());
            return this;
        }

        /**
         * A unique identifier for the component.<p>A unique identifier for the component.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>Styles all options and prevents the action. Default is false. Will be overridden if save_state is saved.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        /**
         * <p>Styles all options and prevents the action. Default is false. Will be overridden if save_state is saved.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "disabled", nulls = Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        /**
         * <p>Styles all options and prevents the action. Default is <code>unsaved</code>. Will be overridden if <code>save_state</code> is <code>saved</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage saveState(SaveState saveState) {
            this.saveState = Optional.ofNullable(saveState);
            return this;
        }

        /**
         * <p>Styles all options and prevents the action. Default is <code>unsaved</code>. Will be overridden if <code>save_state</code> is <code>saved</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "save_state", nulls = Nulls.SKIP)
        public _FinalStage saveState(Optional<SaveState> saveState) {
            this.saveState = saveState;
            return this;
        }

        /**
         * <p>The option that is selected by default.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage value(String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        /**
         * <p>The option that is selected by default.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "value", nulls = Nulls.SKIP)
        public _FinalStage value(Optional<String> value) {
            this.value = value;
            return this;
        }

        /**
         * <p>The text shown above the dropdown.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        /**
         * <p>The text shown above the dropdown.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "label", nulls = Nulls.SKIP)
        public _FinalStage label(Optional<String> label) {
            this.label = label;
            return this;
        }

        /**
         * <p>The list of options. Can provide 2 to 10.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllOptions(List<DropdownOption> options) {
            this.options.addAll(options);
            return this;
        }

        /**
         * <p>The list of options. Can provide 2 to 10.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addOptions(DropdownOption options) {
            this.options.add(options);
            return this;
        }

        /**
         * <p>The list of options. Can provide 2 to 10.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "options", nulls = Nulls.SKIP)
        public _FinalStage options(List<DropdownOption> options) {
            this.options.clear();
            this.options.addAll(options);
            return this;
        }

        @java.lang.Override
        public DropdownComponent build() {
            return new DropdownComponent(id, options, label, value, saveState, disabled, additionalProperties);
        }
    }

    public static final class SaveState {
        public static final SaveState SAVED = new SaveState(Value.SAVED, "saved");

        public static final SaveState UNSAVED = new SaveState(Value.UNSAVED, "unsaved");

        public static final SaveState FAILED = new SaveState(Value.FAILED, "failed");

        private final Value value;

        private final String string;

        SaveState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof SaveState && this.string.equals(((SaveState) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case SAVED:
                    return visitor.visitSaved();
                case UNSAVED:
                    return visitor.visitUnsaved();
                case FAILED:
                    return visitor.visitFailed();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SaveState valueOf(String value) {
            switch (value) {
                case "saved":
                    return SAVED;
                case "unsaved":
                    return UNSAVED;
                case "failed":
                    return FAILED;
                default:
                    return new SaveState(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            UNSAVED,

            SAVED,

            FAILED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitUnsaved();

            T visitSaved();

            T visitFailed();

            T visitUnknown(String unknownType);
        }
    }
}
