/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LinkedObject.Builder.class)
public final class LinkedObject {
    private final Type type;

    private final String id;

    private final Optional<String> category;

    private final Map<String, Object> additionalProperties;

    private LinkedObject(Type type, String id, Optional<String> category, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return ticket or conversation
     */
    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    /**
     * @return The ID of the linked object
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return Category of the Linked Ticket Object.
     */
    @JsonProperty("category")
    public Optional<String> getCategory() {
        return category;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LinkedObject && equalTo((LinkedObject) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkedObject other) {
        return type.equals(other.type) && id.equals(other.id) && category.equals(other.category);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.category);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * ticket or conversation
         */
        IdStage type(@NotNull Type type);

        Builder from(LinkedObject other);
    }

    public interface IdStage {
        /**
         * The ID of the linked object
         */
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        LinkedObject build();

        /**
         * <p>Category of the Linked Ticket Object.</p>
         */
        _FinalStage category(Optional<String> category);

        _FinalStage category(String category);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, _FinalStage {
        private Type type;

        private String id;

        private Optional<String> category = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LinkedObject other) {
            type(other.getType());
            id(other.getId());
            category(other.getCategory());
            return this;
        }

        /**
         * ticket or conversation<p>ticket or conversation</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * The ID of the linked object<p>The ID of the linked object</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>Category of the Linked Ticket Object.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage category(String category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        /**
         * <p>Category of the Linked Ticket Object.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "category", nulls = Nulls.SKIP)
        public _FinalStage category(Optional<String> category) {
            this.category = category;
            return this;
        }

        @java.lang.Override
        public LinkedObject build() {
            return new LinkedObject(type, id, category, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type TICKET = new Type(Value.TICKET, "ticket");

        public static final Type CONVERSATION = new Type(Value.CONVERSATION, "conversation");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case TICKET:
                    return visitor.visitTicket();
                case CONVERSATION:
                    return visitor.visitConversation();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "ticket":
                    return TICKET;
                case "conversation":
                    return CONVERSATION;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            TICKET,

            CONVERSATION,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitTicket();

            T visitConversation();

            T visitUnknown(String unknownType);
        }
    }
}
